/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.mixin;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemCooldowns getCooldowns();

    @Inject(method={"disableShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCrystalShieldBlockingCooldown(CallbackInfo ci) {
        ItemStack usingItem = this.getUseItem();
        int blockCooldownReduction = (Integer)usingItem.getOrDefault(DataComponents.BLOCK_COOLDOWN_REDUCTION, (Object)0);
        if (blockCooldownReduction > 0) {
            if (blockCooldownReduction < 100) {
                this.getCooldowns().addCooldown(usingItem.getItem(), 100 - blockCooldownReduction);
                this.stopUsingItem();
                this.level().broadcastEntityEvent((Entity)this, (byte)30);
            }
            ci.cancel();
        }
    }
}

