/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.network.handler;

import dev.willyelton.crystal_tools.common.inventory.container.CrystalBackpackContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import dev.willyelton.crystal_tools.common.network.data.BackpackScreenPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class BackpackScreenHandler {
    public static BackpackScreenHandler INSTANCE = new BackpackScreenHandler();

    public void handle(BackpackScreenPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt2$temp;
            AbstractContainerMenu patt1$temp;
            Object menu;
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof FilterContainerMenu) {
                menu = (FilterContainerMenu)patt0$temp;
                switch (payload.pickupType()) {
                    case PICKUP_WHITELIST: {
                        menu.setWhitelist(true);
                        break;
                    }
                    case PICKUP_BLACKLIST: {
                        menu.setWhitelist(false);
                        break;
                    }
                    case CLEAR_FILTERS: {
                        menu.clearFilters();
                    }
                }
            }
            if ((patt1$temp = player.containerMenu) instanceof SubScreenContainerMenu) {
                menu = (SubScreenContainerMenu)patt1$temp;
                switch (payload.pickupType()) {
                    case OPEN_COMPRESSION: {
                        menu.openSubScreen(SubScreenType.COMPRESS);
                        break;
                    }
                    case OPEN_FILTER: {
                        menu.openSubScreen(SubScreenType.FILTER);
                        break;
                    }
                    case OPEN_SETTINGS: {
                        menu.openSubScreen(SubScreenType.SETTINGS);
                        break;
                    }
                    case CLOSE_SUB_SCREEN: {
                        menu.closeSubScreen();
                    }
                }
            }
            if ((patt2$temp = player.containerMenu) instanceof CrystalBackpackContainerMenu) {
                menu = (CrystalBackpackContainerMenu)patt2$temp;
                switch (payload.pickupType()) {
                    case SORT: {
                        ((CrystalBackpackContainerMenu)menu).sort();
                        break;
                    }
                    case COMPRESS: {
                        ((CrystalBackpackContainerMenu)menu).compress();
                        break;
                    }
                    case MATCH_CONTENTS: {
                        ((CrystalBackpackContainerMenu)menu).matchContentsFilter(payload.hasShiftDown());
                        break;
                    }
                    case REOPEN_BACKPACK: {
                        ((CrystalBackpackContainerMenu)menu).reopenBackpack();
                    }
                }
            }
        });
    }
}

