/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.network.handler;

import dev.willyelton.crystal_tools.common.compat.curios.CuriosCompatibility;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.EffectData;
import dev.willyelton.crystal_tools.common.network.data.ToolAttributePayload;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ToolAttributeHandler {
    public static ToolAttributeHandler INSTANCE = new ToolAttributeHandler();

    public void handle(ToolAttributePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            ItemStack heldTool = this.getItemStack(player, payload.slotIndex());
            if (!heldTool.isEmpty()) {
                if (payload.id() == -1) {
                    DataComponents.addToComponent(heldTool, payload.key(), payload.value());
                    return;
                }
                int skillPoints = (Integer)heldTool.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
                if (skillPoints == 0) {
                    return;
                }
                int pointsToAdd = Math.min(skillPoints, payload.pointsToSpend());
                ResourceKey<Enchantment> enchantment = ToolAttributeHandler.enchantmentFromString(payload.key());
                if (enchantment != null) {
                    if (enchantment.equals((Object)Enchantments.SILK_TOUCH)) {
                        if ((Integer)heldTool.getOrDefault(DataComponents.FORTUNE_BONUS, (Object)0) == 0) {
                            EnchantmentUtils.addEnchantment(heldTool, enchantment, (int)payload.value(), player);
                        }
                        DataComponents.setValue(heldTool, payload.key(), payload.value());
                    } else if (enchantment.equals((Object)Enchantments.FORTUNE)) {
                        if (!((Boolean)heldTool.getOrDefault(DataComponents.SILK_TOUCH_BONUS, (Object)false)).booleanValue()) {
                            EnchantmentUtils.addEnchantment(heldTool, enchantment, (int)payload.value(), player);
                        }
                        DataComponents.setValue(heldTool, payload.key(), payload.value());
                    } else {
                        if (enchantment.equals((Object)Enchantments.FROST_WALKER)) {
                            heldTool.set(DataComponents.FROST_WALKER, (Object)true);
                        }
                        EnchantmentUtils.addEnchantment(heldTool, enchantment, (int)payload.value(), player);
                    }
                } else if (payload.key().contains("effect_")) {
                    this.addEffectToList(heldTool, payload.key(), payload.value());
                } else {
                    DataComponents.addToComponent(heldTool, payload.key(), payload.value() * (float)pointsToAdd);
                }
                DataComponents.addValueToArray(heldTool, DataComponents.POINTS_ARRAY, payload.id(), pointsToAdd);
            }
        });
    }

    private ItemStack getItemStack(Player player, int slotIndex) {
        if (slotIndex == -1) {
            return ItemStackUtils.getHeldLevelableTool(player);
        }
        if (slotIndex == -2) {
            List<ItemStack> curiosStacks = CuriosCompatibility.getCrystalBackpacksInCurios(player);
            if (!curiosStacks.isEmpty()) {
                return curiosStacks.getFirst();
            }
            return ItemStack.EMPTY.copy();
        }
        return player.getInventory().getItem(slotIndex);
    }

    private void addEffectToList(ItemStack stack, String key, float value) {
        String effectKey = key.substring(7);
        List currentEffects = (List)stack.getOrDefault(DataComponents.EFFECTS, new ArrayList());
        ArrayList<EffectData> newEffects = new ArrayList<EffectData>();
        boolean added = false;
        for (EffectData effect : currentEffects) {
            if (effect.resourceLocation().equals(effectKey)) {
                newEffects.add(new EffectData(effectKey, effect.duration() + (int)value));
                added = true;
                continue;
            }
            newEffects.add(new EffectData(effect.resourceLocation(), effect.duration()));
        }
        if (!added) {
            newEffects.add(new EffectData(effectKey, (int)value));
        }
        stack.set(DataComponents.EFFECTS, newEffects);
    }

    private static ResourceKey<Enchantment> enchantmentFromString(String string) {
        return switch (string) {
            case "silk_touch_bonus" -> Enchantments.SILK_TOUCH;
            case "fortune_bonus" -> Enchantments.FORTUNE;
            case "looting_bonus" -> Enchantments.LOOTING;
            case "protection_bonus" -> Enchantments.PROTECTION;
            case "fire_protection_bonus" -> Enchantments.FIRE_PROTECTION;
            case "blast_protection_bonus" -> Enchantments.BLAST_PROTECTION;
            case "projectile_protection_bonus" -> Enchantments.PROJECTILE_PROTECTION;
            case "feather_falling_bonus" -> Enchantments.FEATHER_FALLING;
            case "soul_speed_bonus" -> Enchantments.SOUL_SPEED;
            case "frost_walker_bonus" -> Enchantments.FROST_WALKER;
            case "aqua_affinity_bonus" -> Enchantments.AQUA_AFFINITY;
            case "respiration_bonus" -> Enchantments.RESPIRATION;
            case "thorns_bonus" -> Enchantments.THORNS;
            case "depth_strider_bonus" -> Enchantments.DEPTH_STRIDER;
            case "arrow_knockback" -> Enchantments.PUNCH;
            case "sweeping_edge" -> Enchantments.SWEEPING_EDGE;
            case "swift_sneak" -> Enchantments.SWIFT_SNEAK;
            default -> null;
        };
    }
}

