/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.Registration;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CrystalToolsBlockStates
extends BlockStateProvider {
    public CrystalToolsBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "crystal_tools", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)Registration.CRYSTAL_BLOCK.get());
        this.simpleBlock((Block)Registration.CRYSTAL_ORE.get());
        this.simpleBlock((Block)Registration.CRYSTAL_DEEPSLATE_ORE.get());
        this.registerCrystalTorch();
        this.registerCrystalWallTorch();
        this.registerMachineBlock(Registration.CRYSTAL_FURNACE, "crystal_furnace");
        this.registerMachineBlock(Registration.CRYSTAL_GENERATOR, "crystal_generator");
        this.registerMachineBlock(Registration.CRYSTAL_QUARRY, "crystal_quarry");
        this.simpleBlock((Block)Registration.QUARRY_STABILIZER.get(), (ModelFile)this.models().getExistingFile(Registration.QUARRY_STABILIZER.getId()));
    }

    private void registerCrystalTorch() {
        BlockModelBuilder crystalTorchModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Registration.CRYSTAL_TORCH.getId().getPath())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/template_torch")))).renderType("cutout")).texture("torch", this.modLoc("block/crystal_torch"));
        this.simpleBlock((Block)Registration.CRYSTAL_TORCH.get(), (ModelFile)crystalTorchModel);
    }

    private void registerCrystalWallTorch() {
        BlockModelBuilder crystalTorchModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Registration.CRYSTAL_WALL_TORCH.getId().getPath())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/template_torch_wall")))).renderType("cutout")).texture("torch", this.modLoc("block/crystal_torch"));
        this.horizontalBlock((Block)Registration.CRYSTAL_WALL_TORCH.get(), (ModelFile)crystalTorchModel, 90);
    }

    private void registerMachineBlock(DeferredHolder<Block, ?> holder, String name) {
        BlockModelBuilder offState = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(holder.getId().getPath())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("orientable")))).texture("top", this.modLoc(String.format("block/%s_top", name)))).texture("front", this.modLoc(String.format("block/%s_front_off", name)))).texture("side", this.modLoc(String.format("block/%s_side", name)));
        BlockModelBuilder onState = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(holder.getId().getPath() + "_on")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("orientable")))).texture("top", this.modLoc(String.format("block/%s_top", name)))).texture("front", this.modLoc(String.format("block/%s_front_on", name)))).texture("side", this.modLoc(String.format("block/%s_side", name)));
        this.horizontalBlock((Block)holder.get(), blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? onState : offState);
    }
}

