/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.Registration;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class CrystalToolsItemModels
extends ItemModelProvider {
    public CrystalToolsItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "crystal_tools", existingFileHelper);
    }

    protected void registerModels() {
        this.withExistingParent(Registration.CRYSTAL_BLOCK.getId().getPath(), this.modLoc("block/crystal_block"));
        this.withExistingParent(Registration.CRYSTAL_ORE.getId().getPath(), this.modLoc("block/crystal_ore"));
        this.withExistingParent(Registration.CRYSTAL_DEEPSLATE_ORE.getId().getPath(), this.modLoc("block/crystal_deepslate_ore"));
        this.withExistingParent(Registration.CRYSTAL_FURNACE.getId().getPath(), this.modLoc("block/crystal_furnace"));
        this.withExistingParent(Registration.CRYSTAL_GENERATOR.getId().getPath(), this.modLoc("block/crystal_generator"));
        this.withExistingParent(Registration.CRYSTAL_QUARRY.getId().getPath(), this.modLoc("block/crystal_quarry"));
        ((ItemModelBuilder)this.withExistingParent(Registration.CRYSTAL_TORCH.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/crystal_torch"));
        this.withExistingParent(Registration.QUARRY_STABILIZER.getId().getPath(), this.modLoc("block/quarry_stabilizer"));
        this.withExistingParent(Registration.CRYSTAL_PEDESTAL.getId().getPath(), this.modLoc("block/crystal_pedestal"));
        this.basicItem((Item)Registration.CRYSTAL.get());
        this.toolItem((Item)Registration.NETHERITE_STICK.get());
        this.basicItem((Item)Registration.CRYSTAL_APPLE.get());
        this.basicItem((Item)Registration.CRYSTAL_BACKPACK.get());
        this.basicItem((Item)Registration.CRYSTAL_MAGNET.get());
        this.toolItem((Item)Registration.CRYSTAL_AIOT.get());
        this.toolItem((Item)Registration.CRYSTAL_AXE.get());
        this.toolItem((Item)Registration.CRYSTAL_HOE.get());
        this.toolItem((Item)Registration.CRYSTAL_PICKAXE.get());
        this.toolItem((Item)Registration.CRYSTAL_ROCKET.get());
        this.toolItem((Item)Registration.CRYSTAL_SHOVEL.get());
        this.toolItem((Item)Registration.CRYSTAL_SWORD.get());
        this.registerBow();
        this.registerTrident();
        this.registerFishingRod();
        this.toolItem((Item)Registration.PORTABLE_GENERATOR.get());
        this.basicItem((Item)Registration.CRYSTAL_HELMET.get());
        this.basicItem((Item)Registration.CRYSTAL_CHESTPLATE.get());
        this.basicItem((Item)Registration.CRYSTAL_LEGGINGS.get());
        this.basicItem((Item)Registration.CRYSTAL_BOOTS.get());
        this.basicItem((Item)Registration.CRYSTAL_ELYTRA.get());
    }

    private ItemModelBuilder toolItem(Item item) {
        ResourceLocation resourceLocation = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(resourceLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)("item/" + resourceLocation.getPath())));
    }

    private void registerBow() {
        ModelFile[] bowModels = new ModelFile[3];
        for (int i = 0; i < 3; ++i) {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)("item/crystal_bow_pulling_" + i));
            bowModels[i] = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(resourceLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("crystal_tools:item/crystal_bow"))).texture("layer0", resourceLocation);
        }
        ((ItemModelBuilder)this.basicItem((Item)Registration.CRYSTAL_BOW.get()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-80.0f, 260.0f, -40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f, 0.9f, 0.9f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-80.0f, -280.0f, 40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f, 0.9f, 0.9f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().end()).override().predicate(this.mcLoc("pulling"), 1.0f).model(bowModels[0]).end().override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 0.65f).model(bowModels[1]).end().override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 0.9f).model(bowModels[2]).end();
    }

    private void registerTrident() {
        ResourceLocation tridentLocation = Registration.CRYSTAL_TRIDENT.getId();
        ResourceLocation tridentTextureLocation = ResourceLocation.fromNamespaceAndPath((String)tridentLocation.getNamespace(), (String)("item/" + tridentLocation.getPath()));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(String.valueOf(tridentLocation) + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", tridentTextureLocation);
        ModelBuilder throwingModel = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(String.valueOf(tridentLocation) + "_throwing")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", tridentTextureLocation)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, 9.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, -7.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f, 0.5f, 0.5f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(4.0f, 4.0f, 2.0f).scale(0.25f, 0.25f, 0.25f).end().end();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(tridentLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", tridentTextureLocation)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(11.0f, 17.0f, -2.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(3.0f, 17.0f, 12.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f, 0.5f, 0.5f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(4.0f, 4.0f, 2.0f).scale(0.25f, 0.25f, 0.25f).end().end()).override().predicate(this.mcLoc("throwing"), 1.0f).model((ModelFile)throwingModel).end();
    }

    private void registerFishingRod() {
        ResourceLocation fishingRodId = Registration.CRYSTAL_FISHING_ROD.getId();
        ModelBuilder castModel = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(String.valueOf(fishingRodId) + "_cast")).parent((ModelFile)new ModelFile.UncheckedModelFile("crystal_tools:item/crystal_fishing_rod"))).texture("layer0", this.modLoc("item/crystal_fishing_rod_cast"));
        ((ItemModelBuilder)this.basicItem((Item)Registration.CRYSTAL_FISHING_ROD.get()).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld_rod"))).override().predicate(this.mcLoc("cast"), 1.0f).model((ModelFile)castModel).end();
    }
}

