/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalTorch;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class CrystalToolsLootTables
extends VanillaBlockLoot {
    public CrystalToolsLootTables(HolderLookup.Provider provider) {
        super(provider);
    }

    protected void generate() {
        this.dropSelf((Block)Registration.CRYSTAL_BLOCK.get());
        this.dropSelf((Block)Registration.QUARRY_STABILIZER.get());
        this.dropSelf((Block)Registration.CRYSTAL_PEDESTAL.get());
        this.add((Block)Registration.CRYSTAL_ORE.get(), this.createOreDrop((Block)Registration.CRYSTAL_ORE.get(), (Item)Registration.CRYSTAL.get()));
        this.add((Block)Registration.CRYSTAL_DEEPSLATE_ORE.get(), this.createOreDrop((Block)Registration.CRYSTAL_DEEPSLATE_ORE.get(), (Item)Registration.CRYSTAL.get()));
        this.createTorchTable((Block)Registration.CRYSTAL_TORCH.get());
        this.createComponentSavingTable((Block)Registration.CRYSTAL_FURNACE.get(), (DataComponentType)DataComponents.FURNACE_DATA.get(), (DataComponentType)DataComponents.FURNACE_UPGRADES.get(), (DataComponentType)DataComponents.LEVELABLE_BLOCK_ENTITY_DATA.get(), (DataComponentType)DataComponents.FURNACE_INVENTORY.get(), (DataComponentType)DataComponents.AUTO_OUTPUT.get());
        this.createComponentSavingTable((Block)Registration.CRYSTAL_GENERATOR.get(), (DataComponentType)DataComponents.LEVELABLE_BLOCK_ENTITY_DATA.get(), (DataComponentType)DataComponents.GENERATOR_DATA.get(), (DataComponentType)DataComponents.GENERATOR_UPGRADES.get(), net.minecraft.core.component.DataComponents.CONTAINER);
        this.createComponentSavingTable((Block)Registration.CRYSTAL_QUARRY.get(), (DataComponentType)DataComponents.LEVELABLE_BLOCK_ENTITY_DATA.get(), net.minecraft.core.component.DataComponents.CONTAINER, (DataComponentType)DataComponents.QUARRY_BOUNDS.get(), (DataComponentType)DataComponents.QUARRY_DATA.get(), (DataComponentType)DataComponents.QUARRY_UPGRADES.get(), (DataComponentType)DataComponents.QUARRY_SETTINGS.get(), (DataComponentType)DataComponents.QUARRY_FILTER.get(), (DataComponentType)DataComponents.AUTO_OUTPUT.get(), (DataComponentType)DataComponents.CHUNKLOADING.get());
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("crystal_tools")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void createComponentSavingTable(Block block, DataComponentType<?> ... dataComponents) {
        LootPoolSingletonContainer.Builder lti = LootItem.lootTableItem((ItemLike)block);
        lti.apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
        CopyComponentsFunction.Builder copyComponentsFunctionBuilder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
        for (DataComponentType<?> dataComponent : dataComponents) {
            copyComponentsFunctionBuilder.include(dataComponent);
        }
        lti.apply((LootItemFunction.Builder)copyComponentsFunctionBuilder);
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)lti);
        this.add(block, LootTable.lootTable().withPool(builder));
    }

    private void createTorchTable(Block block) {
        LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CrystalTorch.DROP_ITEM, true)), LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)Registration.CRYSTAL_WALL_TORCH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CrystalTorch.DROP_ITEM, true))})).add((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)block)));
        this.add(block, LootTable.lootTable().withPool(builder));
    }
}

