/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.crafting.CrystalAIOTRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalElytraRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalGeneratorRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalQuarryRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalShieldTotemRecipe;
import dev.willyelton.crystal_tools.common.crafting.ItemDisabledCondition;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;

public class CrystalToolsRecipes
extends RecipeProvider {
    private static final Criterion<InventoryChangeTrigger.TriggerInstance> HAS_CRYSTAL = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Registration.CRYSTAL.get()});

    public CrystalToolsRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.CRYSTAL.get()), (int)9).requires((ItemLike)Registration.CRYSTAL_BLOCK.get()).unlockedBy("has_crystal_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Registration.CRYSTAL_BLOCK.get()})).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)Registration.CRYSTAL_BLOCK.get())).pattern("ccc").pattern("ccc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.NETHERITE_STICK.get()), (int)4).pattern("n").pattern("n").define(Character.valueOf('n'), Tags.Items.INGOTS_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.CRYSTAL_TORCH.get()), (int)4).pattern("c").pattern("s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_AXE.get())).pattern("cc").pattern("cs").pattern(" s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_AXE.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_HOE.get())).pattern("cc").pattern(" s").pattern(" s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_HOE.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_PICKAXE.get())).pattern("ccc").pattern(" s ").pattern(" s ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_PICKAXE.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_SHOVEL.get())).pattern("c").pattern("s").pattern("s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_SHOVEL.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)Registration.CRYSTAL_SWORD.get())).pattern("c").pattern("c").pattern("s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_SWORD.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)Registration.CRYSTAL_BOW.get())).pattern(" sc").pattern("s c").pattern(" sc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_BOW.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)Registration.CRYSTAL_APPLE.get())).pattern("ccc").pattern("cac").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('a'), (ItemLike)Items.ENCHANTED_GOLDEN_APPLE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_APPLE.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_ROCKET.get())).pattern("ccc").pattern("crc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('r'), (ItemLike)Items.FIREWORK_ROCKET).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_ROCKET.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_TRIDENT.get())).pattern("ccc").pattern("sts").pattern(" s ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('t'), (ItemLike)Items.TRIDENT).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_TRIDENT.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_FISHING_ROD.get())).pattern("  s").pattern(" st").pattern("s c").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('t'), (ItemLike)Items.STRING).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_FISHING_ROD.getId());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.CRYSTAL_SHIELD.get())).pattern(" c ").pattern("tsc").pattern(" c ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('t'), (ItemLike)Registration.NETHERITE_STICK.get()).define(Character.valueOf('s'), (ItemLike)Items.SHIELD).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_MAGNET.get())).pattern(" cr").pattern("cic").pattern("rc ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.PORTABLE_GENERATOR.get())).pattern(" p ").pattern("pgp").pattern(" s ").define(Character.valueOf('p'), (ItemLike)Items.PISTON).define(Character.valueOf('g'), (ItemLike)Registration.CRYSTAL_GENERATOR.get()).define(Character.valueOf('s'), (ItemLike)Registration.NETHERITE_STICK.get()).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_HELMET.get())).pattern("ccc").pattern("c c").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_HELMET.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_CHESTPLATE.get())).pattern("c c").pattern("ccc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_CHESTPLATE.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_LEGGINGS.get())).pattern("ccc").pattern("c c").pattern("c c").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_LEGGINGS.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_BOOTS.get())).pattern("c c").pattern("c c").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_BOOTS.getId());
        this.buildConditionalRecipe(recipeOutput, ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)Registration.CRYSTAL_BACKPACK.get())).pattern("lcl").pattern("chc").pattern("lcl").define(Character.valueOf('l'), (ItemLike)Items.LEATHER).define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('h'), (ItemLike)Items.CHEST).unlockedBy("has_crystal", HAS_CRYSTAL), Registration.CRYSTAL_BACKPACK.getId());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.CRYSTAL_FURNACE.get())).pattern("ccc").pattern("cfc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('f'), (ItemLike)Items.FURNACE).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.QUARRY_STABILIZER.get()), (int)4).pattern("c").pattern("n").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('n'), (ItemLike)Items.NETHERITE_INGOT).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.CRYSTAL_PEDESTAL.get())).pattern("n").pattern("b").pattern("c").define(Character.valueOf('n'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('b'), (ItemLike)Registration.CRYSTAL_BLOCK.get()).define(Character.valueOf('c'), (ItemLike)Items.CHEST).unlockedBy("has_crystal", HAS_CRYSTAL).save(recipeOutput);
        SpecialRecipeBuilder.special(CrystalAIOTRecipe::new).save(recipeOutput, Registration.CRYSTAL_AIOT.getId().toString());
        SpecialRecipeBuilder.special(CrystalElytraRecipe::new).save(recipeOutput, Registration.CRYSTAL_ELYTRA.getId().toString());
        SpecialRecipeBuilder.special(CrystalGeneratorRecipe::new).save(recipeOutput, Registration.CRYSTAL_GENERATOR_ITEM.getId().toString());
        SpecialRecipeBuilder.special(CrystalQuarryRecipe::new).save(recipeOutput, Registration.CRYSTAL_QUARRY_ITEM.getId().toString());
        SpecialRecipeBuilder.special(CrystalShieldTotemRecipe::new).save(recipeOutput, String.valueOf(Registration.CRYSTAL_SHIELD.getId()) + "_totem");
    }

    private void buildConditionalRecipe(RecipeOutput recipeOutput, ShapedRecipeBuilder builder, ResourceLocation conditionItem) {
        builder.save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new ItemDisabledCondition(conditionItem))}), conditionItem);
    }
}

