/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.datagen.CrystalToolsBlockStates;
import dev.willyelton.crystal_tools.datagen.CrystalToolsBlockTags;
import dev.willyelton.crystal_tools.datagen.CrystalToolsDataMaps;
import dev.willyelton.crystal_tools.datagen.CrystalToolsEntityTypeTags;
import dev.willyelton.crystal_tools.datagen.CrystalToolsItemModels;
import dev.willyelton.crystal_tools.datagen.CrystalToolsItemTags;
import dev.willyelton.crystal_tools.datagen.CrystalToolsLootTables;
import dev.willyelton.crystal_tools.datagen.CrystalToolsRecipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGeneration {
    public static void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new CrystalToolsBlockStates(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new CrystalToolsItemModels(packOutput, event.getExistingFileHelper()));
        CrystalToolsBlockTags blockTags = new CrystalToolsBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        CrystalToolsItemTags itemTags = new CrystalToolsItemTags(packOutput, lookupProvider, blockTags.contentsGetter(), event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        CrystalToolsEntityTypeTags entityTypeTags = new CrystalToolsEntityTypeTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)entityTypeTags);
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(CrystalToolsLootTables::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new CrystalToolsRecipes(packOutput, event.getLookupProvider()));
        CrystalToolsDataMaps dataMaps = new CrystalToolsDataMaps(packOutput, lookupProvider);
        generator.addProvider(event.includeServer(), (DataProvider)dataMaps);
    }
}

