/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NBTUtils {
    public static int[] getIntArray(CompoundTag tag, String arrayKey, int size) {
        int[] array;
        if (tag.contains(arrayKey)) {
            array = tag.getIntArray(arrayKey);
            if (array.length == 0 && size > 0) {
                array = new int[size];
            }
        } else {
            array = size >= 0 ? new int[size] : new int[]{};
        }
        return array;
    }

    public static void storeItemStackArray(CompoundTag tag, List<ItemStack> stackList, HolderLookup.Provider levelRegistry) {
        ListTag listTag = new ListTag();
        for (ItemStack stack : stackList) {
            CompoundTag stackTag = new CompoundTag();
            listTag.add((Object)stack.save(levelRegistry, (Tag)stackTag));
        }
        if (!listTag.isEmpty()) {
            tag.put("Items", (Tag)listTag);
        }
    }

    public static List<ItemStack> getItemStackArray(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListTag listTag = tag.getList("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag stackTag = listTag.getCompound(i);
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)levelRegistry, (Tag)stackTag).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        return stacks;
    }
}

