/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillTreeRegistry;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ToolUtils {
    public static boolean isBroken(ItemStack stack) {
        int durability = stack.getItem().getMaxDamage(stack) - stack.getDamageValue();
        return durability <= 1;
    }

    public static boolean willBreak(ItemStack stack, int durabilityToUse) {
        return stack.getMaxDamage() - stack.getDamageValue() <= durabilityToUse;
    }

    public static void increaseExpCap(ItemStack stack) {
        ToolUtils.increaseExpCap(stack, 1);
    }

    public static void increaseExpCap(ItemStack stack, int levelIncrease) {
        Item item = stack.getItem();
        if (item instanceof LevelableItem) {
            LevelableItem item2 = (LevelableItem)item;
            int experienceCap = item2.getExperienceCap(stack);
            int newCap = ToolUtils.getNewCap(experienceCap, levelIncrease);
            stack.set(DataComponents.EXPERIENCE_CAP, (Object)newCap);
        }
    }

    public static int getNewCap(int currentCap, int levelIncrease) {
        return (int)Math.min((float)((double)currentCap * Math.pow((Double)CrystalToolsConfig.EXPERIENCE_MULTIPLIER.get(), levelIncrease)), (float)((Integer)CrystalToolsConfig.MAX_EXP.get()).intValue());
    }

    public static void resetPoints(ItemStack stack) {
        List points = (List)stack.getOrDefault(DataComponents.POINTS_ARRAY, Collections.emptyList());
        int skillPoints = (Integer)stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>(DataComponents.FLOAT_COMPONENTS.values());
        resourceLocations.addAll(DataComponents.INT_COMPONENTS.values());
        resourceLocations.addAll(DataComponents.BOOLEAN_COMPONENTS.values());
        for (ResourceLocation resourceLocation : resourceLocations) {
            DataComponentType dataComponent = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(resourceLocation);
            if (dataComponent == null) continue;
            stack.remove(dataComponent);
        }
        stack.set(DataComponents.POINTS_ARRAY, Collections.emptyList());
        stack.set(DataComponents.SKILL_POINTS, (Object)(skillPoints += points.stream().reduce(0, Integer::sum).intValue()));
        stack.remove(DataComponents.EFFECTS);
    }

    public static SkillData getSkillData(ItemStack stack) {
        List points = (List)stack.getOrDefault(DataComponents.POINTS_ARRAY, Collections.emptyList());
        if (stack.getItem() instanceof LevelableItem) {
            String toolType = ((LevelableItem)stack.getItem()).getItemType();
            SkillData data = SkillTreeRegistry.SKILL_TREES.get(toolType);
            data.applyPoints(points);
            return data;
        }
        return null;
    }

    public static boolean isValidEntity(LivingEntity entity) {
        return !entity.getType().is(CrystalToolsTags.ENTITY_BLACKLIST);
    }

    public static List<ItemStack> getFilterItems(ItemStack stack) {
        ItemContainerContents filterContents = (ItemContainerContents)stack.get(DataComponents.FILTER_INVENTORY);
        if (filterContents == null) {
            return Collections.emptyList();
        }
        return filterContents.stream().filter(stack1 -> !stack1.isEmpty()).toList();
    }

    public static boolean matchesFilter(ItemStack stack, ItemStack toMatch, List<ItemStack> filter) {
        if ((Integer)stack.getOrDefault(DataComponents.FILTER_CAPACITY, (Object)0) == 0) {
            return true;
        }
        boolean whiteList = (Boolean)stack.getOrDefault(DataComponents.WHITELIST, (Object)true);
        for (ItemStack filterStack : filter) {
            if (!filterStack.is(toMatch.getItem())) continue;
            return whiteList;
        }
        return !whiteList;
    }
}

