/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import java.util.UUID;
import mythicbotany.config.MythicConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import tcintegrations.common.capabilities.CapabilityRegistry;
import tcintegrations.items.TCIntegrationHooks;
import tcintegrations.items.TCIntegrationsModifiers;
import tcintegrations.items.modifiers.hooks.IArmorJumpModifier;
import tcintegrations.network.BotaniaSetData;
import tcintegrations.network.NetworkHandler;
import tcintegrations.util.BotaniaClientHelper;
import tcintegrations.util.BotaniaHelper;
import vazkii.botania.api.mana.ManaItemHandler;

public class AlfheimModifier
extends Modifier
implements IArmorJumpModifier,
EquipmentChangeModifierHook,
InventoryTickModifierHook {
    private static final int MANA_PER_DAMAGE = 110;
    private static final AttributeModifier HELMET_REACH_DISTANCE = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.HELMET), "Helmet Reach Distance", MythicConfig.alftools.reach_modifier, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_KNOCKBACK_RESISTANCE = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.CHESTPLATE), "Chestplate Knockback Resistance", MythicConfig.alftools.knockback_resistance_modifier, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_MOVEMENT_SPEED = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.LEGGINGS), "Leggings Movement Speed", MythicConfig.alftools.speed_modifier, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_SWIM_SPEED = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.LEGGINGS), "Leggings Swim Speed", MythicConfig.alftools.speed_modifier, AttributeModifier.Operation.ADDITION);

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, TCIntegrationHooks.JUMP, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.INVENTORY_TICK);
    }

    public int getManaPerDamage(ServerPlayer sp) {
        return BotaniaHelper.getManaPerDamageBonus((Player)sp, 110);
    }

    @NotNull
    public Component getDisplayName(int level) {
        return this.applyStyle(Component.m_237115_((String)this.getTranslationKey()));
    }

    public MutableComponent applyStyle(MutableComponent component) {
        if (BotaniaClientHelper.hasAlfheimArmorSet()) {
            return component.m_130938_(style -> style.m_131148_(this.getTextColor()));
        }
        return component.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.STRIKETHROUGH);
    }

    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
                boolean hasSet = this.hasArmorSetItem(sp, EquipmentSlot.HEAD) && this.hasArmorSetItem(sp, EquipmentSlot.CHEST) && this.hasArmorSetItem(sp, EquipmentSlot.LEGS) && this.hasArmorSetItem(sp, EquipmentSlot.FEET);
                data.setAlfheim(hasSet);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new BotaniaSetData(data.hasTerrestrial(), data.hasGreatFairy(), hasSet));
            });
            this.changeEquipment(sp, context, false);
        }
    }

    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
                data.setTerrestrial(false);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new BotaniaSetData(data.hasTerrestrial(), data.hasGreatFairy(), false));
            });
            this.changeEquipment(sp, context, true);
        }
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        Player player;
        Player player2 = player = holder instanceof Player ? (Player)holder : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.f_19797_ % 20 == 0 && tool.getDamage() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, (Player)sp, this.getManaPerDamage(sp), true)) {
                tool.setDamage(tool.getDamage() - 1);
            }
        }
    }

    public boolean hasArmorSetItem(ServerPlayer sp, EquipmentSlot slot) {
        ItemStack stack = sp.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        ToolStack armor = ToolStack.from((ItemStack)stack);
        if (armor.isBroken()) {
            return false;
        }
        return armor.getUpgrades().getLevel(TCIntegrationsModifiers.ALFHEIM_MODIFIER.getId()) > 0;
    }

    public void changeEquipment(ServerPlayer sp, EquipmentChangeContext context, boolean remove) {
        AttributeInstance reachDistance = sp.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        AttributeInstance knockbackResistance = sp.m_21051_(Attributes.f_22278_);
        AttributeInstance movementSpeed = sp.m_21051_(Attributes.f_22279_);
        AttributeInstance swimSpeed = sp.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (context.getChangedSlot() == EquipmentSlot.LEGS && movementSpeed != null) {
            if (remove && movementSpeed.m_22109_(LEGGINGS_MOVEMENT_SPEED)) {
                movementSpeed.m_22130_(LEGGINGS_MOVEMENT_SPEED);
            } else if (!movementSpeed.m_22109_(LEGGINGS_MOVEMENT_SPEED)) {
                movementSpeed.m_22125_(LEGGINGS_MOVEMENT_SPEED);
            }
        }
        if (context.getChangedSlot() == EquipmentSlot.LEGS && swimSpeed != null) {
            if (remove && swimSpeed.m_22109_(LEGGINGS_SWIM_SPEED)) {
                swimSpeed.m_22130_(LEGGINGS_SWIM_SPEED);
            } else if (!swimSpeed.m_22109_(LEGGINGS_SWIM_SPEED)) {
                swimSpeed.m_22125_(LEGGINGS_SWIM_SPEED);
            }
        }
        if (context.getChangedSlot() == EquipmentSlot.CHEST && knockbackResistance != null) {
            if (remove && knockbackResistance.m_22109_(CHESTPLATE_KNOCKBACK_RESISTANCE)) {
                knockbackResistance.m_22130_(CHESTPLATE_KNOCKBACK_RESISTANCE);
            } else if (!knockbackResistance.m_22109_(CHESTPLATE_KNOCKBACK_RESISTANCE)) {
                knockbackResistance.m_22125_(CHESTPLATE_KNOCKBACK_RESISTANCE);
            }
        }
        if (context.getChangedSlot() == EquipmentSlot.HEAD && reachDistance != null) {
            if (remove && reachDistance.m_22109_(HELMET_REACH_DISTANCE)) {
                reachDistance.m_22130_(HELMET_REACH_DISTANCE);
            } else if (!reachDistance.m_22109_(HELMET_REACH_DISTANCE)) {
                reachDistance.m_22125_(HELMET_REACH_DISTANCE);
            }
        }
    }

    @Override
    public void onJump(IToolStackView tool, LivingEntity living) {
        float rot = living.m_146908_() * ((float)Math.PI / 180);
        float xzFactor = living.m_20142_() ? MythicConfig.alftools.jump_modifier : 0.0f;
        living.m_20256_(living.m_20184_().m_82520_((double)(-Mth.m_14031_((float)rot) * xzFactor), (double)MythicConfig.alftools.jump_modifier, (double)(Mth.m_14089_((float)rot) * xzFactor)));
    }
}

