/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.network.PacketDistributor;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import tcintegrations.common.capabilities.ArsElementalSet;
import tcintegrations.common.capabilities.CapabilityRegistry;
import tcintegrations.items.TCIntegrationsModifiers;
import tcintegrations.network.ArsElementalSetData;
import tcintegrations.network.NetworkHandler;

public class ArsElementalSetBase
extends Modifier
implements EquipmentChangeModifierHook,
ModifyDamageModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.MODIFY_DAMAGE);
    }

    public Component getDisplayName(int level) {
        return this.applyStyle(Component.m_237115_((String)this.getTranslationKey()));
    }

    public boolean hasArmorSet() {
        return false;
    }

    public MutableComponent applyStyle(MutableComponent component) {
        if (this.hasArmorSet()) {
            return component.m_130938_(style -> style.m_131148_(this.getTextColor()));
        }
        return component.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.STRIKETHROUGH);
    }

    public void setHasSet(ArsElementalSet data, boolean hasSet) {
    }

    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            ItemStack replacement = context.getReplacement();
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            sp.getCapability(CapabilityRegistry.ARS_ELEMENTAL_SET_CAPABILITY).ifPresent(data -> {
                boolean hasSet = this.hasArmorSetItem(sp, EquipmentSlot.HEAD) && this.hasArmorSetItem(sp, EquipmentSlot.CHEST) && this.hasArmorSetItem(sp, EquipmentSlot.LEGS) && this.hasArmorSetItem(sp, EquipmentSlot.FEET);
                this.setHasSet((ArsElementalSet)data, hasSet);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ArsElementalSetData(data.hasAir(), data.hasAqua(), data.hasEarth(), data.hasFire()));
            });
            int modifierLevel = tool.getModifierLevel(TCIntegrationsModifiers.ARS_MODIFIER.get());
            enchantments.put((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT.get(), ++modifierLevel);
            enchantments.put((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT.get(), modifierLevel);
            EnchantmentHelper.m_44865_(enchantments, (ItemStack)replacement);
        }
    }

    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(CapabilityRegistry.ARS_ELEMENTAL_SET_CAPABILITY).ifPresent(data -> {
                this.setHasSet((ArsElementalSet)data, false);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new ArsElementalSetData(data.hasAir(), data.hasAqua(), data.hasEarth(), data.hasFire()));
            });
        }
    }

    public ModifierId getModifierId() {
        return TCIntegrationsModifiers.AETHERMANCER_MODIFIER.getId();
    }

    public boolean hasArmorSetItem(ServerPlayer sp, EquipmentSlot slot) {
        ItemStack stack = sp.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        ToolStack armor = ToolStack.from((ItemStack)stack);
        if (armor.isBroken()) {
            return false;
        }
        return armor.getUpgrades().getLevel(this.getModifierId()) > 0;
    }

    public boolean hasArmorSet(Player player) {
        return false;
    }

    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slot, DamageSource damageSource, float amount, boolean isDirectDamage) {
        Player player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        int bonusReduction = 0;
        if (player != null && !player.m_9236_().f_46443_) {
            if (this.hasArmorSet(player) && damageSource.m_269533_(DamageTypeTags.f_268549_)) {
                bonusReduction += 5;
            } else if (this.hasArmorSet(player) && damageSource.m_269533_(DamageTypeTags.f_268581_)) {
                player.m_20301_(player.m_6062_());
                bonusReduction += 5;
            } else if (this.hasArmorSet(player) && damageSource.m_269533_(DamageTypeTags.f_268745_)) {
                player.m_20095_();
                bonusReduction += 5;
            }
        }
        if (bonusReduction > 0) {
            int finalBonusReduction = bonusReduction;
            com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> {
                mana.addMana((double)amount);
                player.m_7292_(new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 200, finalBonusReduction / 2));
            });
            return amount * (1.0f - (float)bonusReduction / 10.0f);
        }
        return amount;
    }
}

