/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import tcintegrations.util.ResourceLocationHelper;

public class PrecipitateModifier
extends Modifier
implements ConditionalStatModifierHook,
BreakSpeedModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook {
    private static final Component SPEED = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("precipitate.speed")));

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.CONDITIONAL_STAT, ModifierHooks.BREAK_SPEED, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP});
    }

    private float getBonusPercentage(Player player) {
        if (player == null) {
            return 0.1f;
        }
        float maxHealth = player.m_21233_();
        return (maxHealth - player.m_21223_()) / maxHealth;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity holder, FloatToolStat stat, float baseValue, float multiplier) {
        Player player;
        Player player2 = player = holder instanceof Player ? (Player)holder : null;
        if (player != null && !player.m_9236_().f_46443_) {
            if (stat == ToolStats.VELOCITY) {
                return baseValue + baseValue * this.getBonusPercentage(player);
            }
            if (stat == ToolStats.ATTACK_SPEED) {
                return baseValue + baseValue * this.getBonusPercentage(player);
            }
        }
        return baseValue;
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        if (player != null && !player.m_9236_().f_46443_) {
            return damage * (1.0f + this.getBonusPercentage(player));
        }
        return damage;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player != null && key == TooltipKey.SHIFT) {
            TooltipModifierHook.addPercentBoost((Modifier)this, (Component)SPEED, (double)this.getBonusPercentage(player), tooltip);
        }
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction direction, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() + event.getNewSpeed() * (1.0f + this.getBonusPercentage(event.getEntity())));
        }
    }
}

