/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import net.magicflowersmod.Config;
import net.magicflowersmod.MagicFlowersMod;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GhostBlockThread
extends Thread {
    public Level level;
    public BlockPos blockPos;
    public BlockState blockState;
    public Long sleepTime;

    public GhostBlockThread(Level level, BlockPos blockPos) {
        this.level = level;
        this.blockPos = blockPos;
        this.blockState = level.getBlockState(blockPos);
        this.sleepTime = (long)Config.tunnelTime;
    }

    private void justSleep(Long time) {
        try {
            GhostBlockThread.sleep(time);
        }
        catch (InterruptedException e) {
            MagicFlowersMod.LOGGER.warn(String.valueOf(e));
        }
    }

    public void vanish(Level level, BlockPos blockPos) {
        for (Block block : Config.blocks) {
            if (!this.blockState.getBlock().equals(block) && !this.blockState.is(BlockTags.LOGS)) continue;
            MagicFlowersMod.LOGGER.info(this.blockState.getBlock().toString());
            try {
                level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                this.justSleep(this.sleepTime);
                this.level.setBlockAndUpdate(this.blockPos, this.blockState);
            }
            catch (IllegalStateException e) {
                MagicFlowersMod.LOGGER.warn("Somethings wrong with the Ghost Block Threads");
                MagicFlowersMod.LOGGER.warn(e.toString());
            }
            break;
        }
    }

    @Override
    public void run() {
        this.vanish(this.level, this.blockPos);
    }
}

