/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import java.util.ArrayList;
import java.util.List;
import net.magicflowersmod.Config;
import net.magicflowersmod.GhostBlockThread;
import net.magicflowersmod.MagicFlowersMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GhostTunnelThread
extends Thread {
    public Vec3 lookAngle;
    public Level level;
    public BlockPos blockPos;
    public int range;
    public int depth;

    public GhostTunnelThread(Vec3 lookAngle, Level level, BlockPos blockPos) {
        this.lookAngle = lookAngle;
        this.level = level;
        this.blockPos = blockPos;
        this.range = Config.tunnelWidth;
        this.depth = Config.tunnelLength;
    }

    private void justSleep(Long time) {
        try {
            GhostTunnelThread.sleep(time);
        }
        catch (InterruptedException e) {
            MagicFlowersMod.LOGGER.warn(String.valueOf(e));
        }
    }

    public void vanish(BlockPos blockPos) {
        GhostBlockThread ghostBlockThread2 = new GhostBlockThread(this.level, blockPos);
        this.justSleep(100L);
        ghostBlockThread2.start();
    }

    @Override
    public void run() {
        Double lookBlockPosX = this.lookAngle.get(Direction.Axis.X);
        Double lookBlockPosY = this.lookAngle.get(Direction.Axis.Y);
        Double lookBlockPosZ = this.lookAngle.get(Direction.Axis.Z);
        Direction direction = Direction.getNearest((double)lookBlockPosX, (double)lookBlockPosY, (double)lookBlockPosZ);
        for (BlockPos blockPos1 : this.supi(this.blockPos, direction)) {
            this.vanish(blockPos1);
        }
    }

    public List<BlockPos> supi(BlockPos blockPos, Direction direction) {
        int z;
        int y;
        int x;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (direction == Direction.DOWN || direction == Direction.UP) {
            for (x = -this.range; x <= this.range; ++x) {
                for (y = -this.range; y <= this.range; ++y) {
                    for (z = this.depth; z > -this.depth; --z) {
                        positions.add(new BlockPos(blockPos.getX() + x, blockPos.getY() + z, blockPos.getZ() + y));
                    }
                }
            }
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            for (x = -this.range; x <= this.range; ++x) {
                for (y = -this.range; y <= this.range; ++y) {
                    for (z = this.depth; z > -this.depth; --z) {
                        positions.add(new BlockPos(blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z));
                    }
                }
            }
        }
        if (direction == Direction.EAST || direction == Direction.WEST) {
            for (x = -this.range; x <= this.range; ++x) {
                for (y = -this.range; y <= this.range; ++y) {
                    for (z = this.depth; z > -this.depth; --z) {
                        positions.add(new BlockPos(blockPos.getX() + z, blockPos.getY() + y, blockPos.getZ() + x));
                    }
                }
            }
        }
        return positions;
    }
}

