/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import java.util.List;
import net.magicflowersmod.MagicFlowerBlockItem;
import net.magicflowersmod.MagicFlowersMod;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class NezaElitaBlockItem
extends MagicFlowerBlockItem {
    public NezaElitaBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public void used(Level level, Player player, InteractionHand usedHand, UseOnContext context) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        Item item = itemStack.getItem();
        if (player.getCooldowns().isOnCooldown(item)) {
            return;
        }
        player.getCooldowns().addCooldown(item, 100);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        player.playSound(MagicFlowersMod.NEZA_ELITA_HEAL.get());
        player.removeEffect(MobEffects.POISON);
        player.removeEffect(MobEffects.BLINDNESS);
        player.removeEffect(MobEffects.DIG_SLOWDOWN);
        player.removeEffect(MobEffects.HUNGER);
        player.removeEffect(MobEffects.INFESTED);
        player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
        player.removeEffect(MobEffects.WEAKNESS);
        player.removeEffect(MobEffects.WITHER);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"\u00a78Removes bad effects"));
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
    }
}

