/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import java.util.List;
import net.magicflowersmod.GhostTunnelThread;
import net.magicflowersmod.MagicFlowerBlockItem;
import net.magicflowersmod.MagicFlowersMod;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SodereDetaBlockItem
extends MagicFlowerBlockItem {
    public SodereDetaBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public void used(Level level, Player player, InteractionHand usedHand, UseOnContext context) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        Item item = itemStack.getItem();
        if (player.getCooldowns().isOnCooldown(item)) {
            return;
        }
        player.getCooldowns().addCooldown(item, 50);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        if (context != null && !level.isClientSide()) {
            try {
                GhostTunnelThread ghostTunnelThread = new GhostTunnelThread(player.getLookAngle(), level, context.getClickedPos());
                MagicFlowersMod.LOGGER.info(String.valueOf(player.getLookAngle()));
                ghostTunnelThread.start();
            }
            catch (Exception e) {
                MagicFlowersMod.LOGGER.warn("Failed to use ghost tunnel thread");
                MagicFlowersMod.LOGGER.warn(e.toString());
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"\u00a78Creates a ghost tunnel."));
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
    }
}

