/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="magicflowersmod", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.DoubleValue SOLE_OCHIO_BOOST_FACTOR = BUILDER.comment("Sole Ochio boost factor").defineInRange("soleOchioBoostFactor", 1.0, 0.1, 10.0);
    private static final ModConfigSpec.DoubleValue RAGMELA_ORA_BOOST_FACTOR = BUILDER.comment("Ragmela Ora launch factor").defineInRange("ragmelaOraLaunchFactor", 1.0, 0.1, 10.0);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> BLOCK_STRINGS = BUILDER.comment("A list of blocks which are allowed to vanish.").defineListAllowEmpty("blocks", List.of("minecraft:grass_block", "minecraft:dirt", "minecraft:stone", "minecraft:deepslate"), Config::validateItemName);
    private static final ModConfigSpec.IntValue TUNNEL_TIME_NUMBER = BUILDER.comment("The ghost tunnel time").defineInRange("tunnelTime", 15000, 500, 150000);
    private static final ModConfigSpec.IntValue TUNNEL_WIDTH_NUMBER = BUILDER.comment("The ghost tunnel width").defineInRange("tunnelWidth", 1, 1, 5);
    private static final ModConfigSpec.IntValue TUNNEL_LENGTH_NUMBER = BUILDER.comment("The ghost tunnel length").defineInRange("tunnelLength", 3, 1, 10);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static Double soleOchioBoostFactor;
    public static Double ragmelaOraLaunchFactor;
    public static List<Block> blocks;
    public static Integer tunnelTime;
    public static Integer tunnelWidth;
    public static Integer tunnelLength;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    private static boolean validateTagName(Object obj) {
        String tagName;
        return obj instanceof String && ResourceLocation.isValidPath((String)(tagName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        soleOchioBoostFactor = (Double)SOLE_OCHIO_BOOST_FACTOR.get();
        ragmelaOraLaunchFactor = (Double)RAGMELA_ORA_BOOST_FACTOR.get();
        blocks = ((List)BLOCK_STRINGS.get()).stream().map(itemName -> Block.byItem((Item)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))))).collect(Collectors.toList());
        tunnelTime = (Integer)TUNNEL_TIME_NUMBER.get();
        tunnelWidth = (Integer)TUNNEL_WIDTH_NUMBER.get();
        tunnelLength = (Integer)TUNNEL_LENGTH_NUMBER.get();
    }
}

