/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import java.util.List;
import net.magicflowersmod.MagicFlowerBlockItem;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class GanasceBonBlockItem
extends MagicFlowerBlockItem {
    public static final Vec3 ZERO = new Vec3(0.0, 0.0, 0.0);

    public GanasceBonBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public void used(Level level, Player player, InteractionHand usedHand, UseOnContext context) {
        if (level.isClientSide()) {
            return;
        }
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            Double distance = ZERO.distanceTo(player.getDeltaMovement());
            String message = "Speed: %.2f";
            String result = String.format(message, distance);
            player.displayClientMessage((Component)Component.literal((String)result), true);
            return;
        }
        Item item = itemStack.getItem();
        if (player.getCooldowns().isOnCooldown(item)) {
            return;
        }
        player.getCooldowns().addCooldown(item, 100);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        if (!level.getServer().isPublished()) {
            return;
        }
        int i = 0;
        double distance = 100.0;
        for (Player p : level.getServer().getPlayerList().getPlayers()) {
            if (!(player != p & player.closerThan((Entity)p, distance))) continue;
            ++i;
        }
        String message = i == 0 ? "No player detected nearby" : (i == 1 ? "Player detected nearby" : "Players detected nearby: %d");
        String result = String.format(message, i);
        player.displayClientMessage((Component)Component.literal((String)result), true);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"\u00a78Sneek & right click to get your speed"));
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
    }
}

