/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import net.magicflowersmod.Config;
import net.magicflowersmod.GanasceBonBlockItem;
import net.magicflowersmod.NezaElitaBlockItem;
import net.magicflowersmod.RagmelaOraBlockItem;
import net.magicflowersmod.SodereDetaBlockItem;
import net.magicflowersmod.SoleOchioBlockItem;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="magicflowersmod")
public class MagicFlowersMod {
    public static final String MODID = "magicflowersmod";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"magicflowersmod");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"magicflowersmod");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"magicflowersmod");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"magicflowersmod");
    public static final Supplier<SoundEvent> NEZA_ELITA_HEAL = MagicFlowersMod.registerSoundEvent("neza_elita_heal");
    public static final Supplier<SoundEvent> SOLE_OCHIO_EXPLODE = MagicFlowersMod.registerSoundEvent("sole_ochio_explode");
    public static final DeferredBlock<Block> NEZA_ELITA = MagicFlowersMod.registerBlock("neza_elita", () -> new FlowerBlock(MobEffects.MOVEMENT_SPEED, 5.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)), NezaElitaBlockItem.class, new Item.Properties().stacksTo(16));
    public static final DeferredBlock<Block> POTTED_NEZA_ELITA = BLOCKS.register("potted_neza_elita", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, NEZA_ELITA, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> RAGMELA_ORO = MagicFlowersMod.registerBlock("ragmela_oro", () -> new FlowerBlock(MobEffects.MOVEMENT_SPEED, 5.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)), RagmelaOraBlockItem.class, new Item.Properties());
    public static final DeferredBlock<Block> POTTED_RAGMELA_ORO = BLOCKS.register("potted_ragmela_oro", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, RAGMELA_ORO, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SOLE_OCHIO = MagicFlowersMod.registerBlock("sole_ochio", () -> new FlowerBlock(MobEffects.MOVEMENT_SPEED, 5.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)), SoleOchioBlockItem.class, new Item.Properties().stacksTo(16));
    public static final DeferredBlock<Block> POTTED_SOLE_OCHIO = BLOCKS.register("potted_sole_ochio", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, SOLE_OCHIO, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> GANASCE_BON = MagicFlowersMod.registerBlock("ganasce_bon", () -> new FlowerBlock(MobEffects.MOVEMENT_SPEED, 5.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)), GanasceBonBlockItem.class, new Item.Properties().stacksTo(16));
    public static final DeferredBlock<Block> POTTED_GANASCE_BON = BLOCKS.register("potted_ganasce_bon", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, GANASCE_BON, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> SODERE_DETA = MagicFlowersMod.registerBlock("sordere_deta", () -> new FlowerBlock(MobEffects.MOVEMENT_SPEED, 5.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)), SodereDetaBlockItem.class, new Item.Properties().stacksTo(16));
    public static final DeferredBlock<Block> POTTED_SODERE_DETA = BLOCKS.register("potted_sordere_deta", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, SODERE_DETA, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));

    public MagicFlowersMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private static Supplier<SoundEvent> registerSoundEvent(String name) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)id));
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block, Class cl, Item.Properties properties) {
        LOGGER.info("registerBlock");
        DeferredBlock toReturn = BLOCKS.register(name, block);
        try {
            MagicFlowersMod.registerBlockItem(name, toReturn, cl.getConstructor(Block.class, Item.Properties.class), properties);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return toReturn;
    }

    private static <T extends Block> DeferredItem registerBlockItem(String name, DeferredBlock<T> block, Constructor<BlockItem> constructor, Item.Properties properties) {
        LOGGER.info("registerBlockItem");
        return ITEMS.register(name, () -> {
            try {
                return ((BlockItem)constructor.newInstance(block.get(), properties)).asItem();
            }
            catch (Exception e) {
                LOGGER.warn(e.toString());
                return new BlockItem((Block)block.get(), new Item.Properties());
            }
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NEZA_ELITA.getId(), POTTED_NEZA_ELITA);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(RAGMELA_ORO.getId(), POTTED_RAGMELA_ORO);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SOLE_OCHIO.getId(), POTTED_SOLE_OCHIO);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(GANASCE_BON.getId(), POTTED_GANASCE_BON);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SODERE_DETA.getId(), POTTED_SODERE_DETA);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.accept((ItemLike)NEZA_ELITA.asItem());
            event.accept((ItemLike)RAGMELA_ORO.asItem());
            event.accept((ItemLike)SOLE_OCHIO.asItem());
            event.accept((ItemLike)GANASCE_BON.asItem());
            event.accept((ItemLike)SODERE_DETA.asItem());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

