/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import java.util.List;
import net.magicflowersmod.Config;
import net.magicflowersmod.MagicFlowerBlockItem;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class RagmelaOraBlockItem
extends MagicFlowerBlockItem {
    public RagmelaOraBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public void used(Level level, Player player, InteractionHand usedHand, UseOnContext context) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        Item item = itemStack.getItem();
        if (player.getCooldowns().isOnCooldown(item)) {
            return;
        }
        player.getCooldowns().addCooldown(item, 100);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value());
        Vec3 vec32 = player.getDeltaMovement();
        player.setDeltaMovement(vec32.add(0.0, 2.5 * Config.ragmelaOraLaunchFactor, 0.0));
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"\u00a78Launches you in the air"));
        tooltipComponents.add((Component)Component.literal((String)"\u00a78Use with caution"));
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
    }
}

