/*
 * Decompiled with CFR 0.152.
 */
package net.magicflowersmod;

import java.util.List;
import net.magicflowersmod.Config;
import net.magicflowersmod.MagicFlowerBlockItem;
import net.magicflowersmod.MagicFlowersMod;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class SoleOchioBlockItem
extends MagicFlowerBlockItem {
    public SoleOchioBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public void used(Level level, Player player, InteractionHand usedHand, UseOnContext context) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        Item item = itemStack.getItem();
        if (player.getCooldowns().isOnCooldown(item)) {
            return;
        }
        player.getCooldowns().addCooldown(item, 100);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        Double soleOchioBoostFactor = Config.soleOchioBoostFactor;
        if (player.isFallFlying()) {
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
            player.playSound(MagicFlowersMod.SOLE_OCHIO_EXPLODE.get());
            Vec3 lookAngle = player.getLookAngle();
            Vec3 deltaMovement = player.getDeltaMovement();
            player.setDeltaMovement(deltaMovement.add(lookAngle.x * 0.5 * soleOchioBoostFactor + (lookAngle.x * 1.5 - deltaMovement.x) * 2.5 * soleOchioBoostFactor, lookAngle.y * 0.5 * soleOchioBoostFactor + (lookAngle.y * 1.5 - deltaMovement.y) * 2.5 * soleOchioBoostFactor, lookAngle.z * 0.5 * soleOchioBoostFactor + (lookAngle.z * 1.5 - deltaMovement.z) * 2.5 * soleOchioBoostFactor));
        } else {
            player.playSound(SoundEvents.FIRE_EXTINGUISH);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"\u00a78Boosts you while flying with an elytra"));
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
    }
}

