/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.api.Addon;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.yaml.snakeyaml.Yaml;

public class AddonLoader {
    private final File addonsFolder;
    private final List<Addon> loadedAddons = new ArrayList<Addon>();

    public AddonLoader(File addonsFolder) {
        this.addonsFolder = addonsFolder;
    }

    public void loadAddons(JavaPlugin core) {
        File[] files;
        if (!this.addonsFolder.exists()) {
            this.addonsFolder.mkdirs();
        }
        if ((files = this.addonsFolder.listFiles((dir, name) -> name.endsWith(".jar"))) == null || files.length == 0) {
            Bukkit.getLogger().info("[EssentiaX] Keine Addons gefunden.");
            return;
        }
        for (File file : files) {
            try {
                Bukkit.getLogger().info("[EssentiaX] Lade Addon: " + file.getName());
                URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
                try (InputStream addonYml = classLoader.getResourceAsStream("addon.yml");){
                    if (addonYml == null) {
                        Bukkit.getLogger().warning("[EssentiaX] " + file.getName() + " enth\u00e4lt keine addon.yml \u2013 \u00fcberspringe.");
                        continue;
                    }
                    Map data = (Map)new Yaml().load(addonYml);
                    String mainClass = (String)data.get("main");
                    if (mainClass == null) {
                        Bukkit.getLogger().warning("[EssentiaX] " + file.getName() + " hat keine 'main'-Klasse in addon.yml!");
                        continue;
                    }
                    Class<?> clazz = classLoader.loadClass(mainClass);
                    Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (instance instanceof Addon) {
                        Addon addon = (Addon)instance;
                        addon.onEnable(core);
                        this.loadedAddons.add(addon);
                        Bukkit.getLogger().info("[EssentiaX] Addon '" + addon.getName() + "' erfolgreich geladen!");
                        continue;
                    }
                    Bukkit.getLogger().warning("[EssentiaX] " + mainClass + " implementiert nicht Addon!");
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("[EssentiaX] Fehler beim Laden von " + file.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void disableAddons() {
        for (Addon addon : this.loadedAddons) {
            try {
                addon.onDisable();
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("[EssentiaX] Fehler beim Deaktivieren eines Addons: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.loadedAddons.clear();
    }
}

