/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.scholle.essentiax.EssentiaX;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.bukkit.ChatColor;

public class Language {
    private final Map<String, Object> lang;

    public Language(String langCode) {
        InputStream stream = this.getClass().getResourceAsStream("/lang/" + langCode + ".json");
        if (stream == null) {
            stream = this.getClass().getResourceAsStream("/lang/en_us.json");
        }
        if (stream == null) {
            throw new RuntimeException("Default language file en_us.json not found!");
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        this.lang = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public String get(String path) {
        String[] keys = path.split("\\.");
        Object current = this.lang;
        for (String key : keys) {
            if (!(current instanceof Map)) continue;
            current = current.get(key);
        }
        if (current == null) {
            return path;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)current.toString());
    }

    public String get(String path, Map<String, String> replacements) {
        String text = this.get(path);
        String prefixColor = ((EssentiaX)EssentiaX.getPlugin(EssentiaX.class)).getConfig().getString("chat.private.prefix", "&7");
        String msgColor = ((EssentiaX)EssentiaX.getPlugin(EssentiaX.class)).getConfig().getString("chat.private.message", "&f");
        text = text.replace("%prefix%", prefixColor);
        text = text.replace("%msgcolor%", msgColor);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            text = text.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

