/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.AFK;
import de.scholle.essentiax.AFKSpot;
import de.scholle.essentiax.AddonLoader;
import de.scholle.essentiax.AdminWarp;
import de.scholle.essentiax.Back;
import de.scholle.essentiax.Home;
import de.scholle.essentiax.Language;
import de.scholle.essentiax.Msg;
import de.scholle.essentiax.Mute;
import de.scholle.essentiax.Reply;
import de.scholle.essentiax.Spawn;
import de.scholle.essentiax.SpawnPoint;
import de.scholle.essentiax.Tpa;
import de.scholle.essentiax.api.EssentiaXAPI;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentiaX
extends JavaPlugin {
    private Language language;
    private AddonLoader addonLoader;
    private FileConfiguration homesConfig;
    private File homesFile;

    public void onEnable() {
        this.saveDefaultConfig();
        EssentiaXAPI.init(this);
        File addonFolder = new File(this.getDataFolder(), "addons");
        this.addonLoader = new AddonLoader(addonFolder);
        this.addonLoader.loadAddons(this);
        String langCode = this.getConfig().getString("language", "en_us");
        this.language = new Language(langCode);
        this.createHomesFile();
        this.getCommand("spawn").setExecutor((CommandExecutor)new Spawn(this, this.language));
        Home home = new Home(this, this.language);
        this.getCommand("sethome").setExecutor((CommandExecutor)home);
        this.getCommand("home").setExecutor((CommandExecutor)home);
        Tpa tpa = new Tpa(this, this.language);
        this.getCommand("tpa").setExecutor((CommandExecutor)tpa);
        this.getCommand("tpaccept").setExecutor((CommandExecutor)tpa);
        this.getCommand("tpdeny").setExecutor((CommandExecutor)tpa);
        Back back = new Back(this, this.language);
        this.getCommand("back").setExecutor((CommandExecutor)back);
        Mute mute = new Mute(this, this.language);
        this.getCommand("mute").setExecutor((CommandExecutor)mute);
        this.getCommand("unmute").setExecutor((CommandExecutor)mute);
        Reply reply = new Reply(this, mute, this.language);
        Msg msg = new Msg(this, reply, mute, this.language);
        this.getCommand("msg").setExecutor((CommandExecutor)msg);
        this.getCommand("msg").setTabCompleter((TabCompleter)msg);
        this.getCommand("reply").setExecutor((CommandExecutor)reply);
        this.getCommand("reply").setTabCompleter((TabCompleter)reply);
        AFK afk = new AFK(this, this.language);
        this.getCommand("afk").setExecutor((CommandExecutor)afk);
        this.getCommand("afkspot").setExecutor((CommandExecutor)new AFKSpot(this, afk, this.language));
        AdminWarp adminWarp = new AdminWarp(this);
        this.getCommand("adminwarp").setExecutor((CommandExecutor)adminWarp);
        this.getCommand("adminwarpback").setExecutor((CommandExecutor)adminWarp);
        SpawnPoint spawnPoint = new SpawnPoint(this);
        this.getCommand("spawnpoint").setExecutor((sender, command, label, args) -> {
            if (!(sender instanceof Player)) {
                return true;
            }
            Player player = (Player)sender;
            spawnPoint.setSpawn(player);
            return true;
        });
        this.getLogger().info("EssentiaX has been successfully enabled!");
    }

    public void createHomesFile() {
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            this.homesFile.getParentFile().mkdirs();
            this.saveResource("homes.yml", false);
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    public FileConfiguration getHomesConfig() {
        return this.homesConfig;
    }

    public void saveHomesConfig() {
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

