/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.ConfigHelper;
import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Home
implements CommandExecutor {
    private final EssentiaX plugin;
    private final Language lang;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public Home(EssentiaX plugin, Language lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long remaining;
        String name;
        if (!(sender instanceof Player)) {
            return true;
        }
        final Player player = (Player)sender;
        if (!ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "home.enabled", true)) {
            return true;
        }
        if (args.length == 0) {
            name = "";
        } else if (args.length == 1) {
            name = args[0].toLowerCase();
        } else {
            return true;
        }
        final int standTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "home.stand-still-time", 5);
        int cooldown = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "home.cooldown", 0);
        int maxHomes = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "home.max-homes", 3);
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(player.getUniqueId()) && (remaining = (this.cooldowns.get(player.getUniqueId()) + (long)cooldown * 1000L - now) / 1000L) > 0L) {
            player.sendMessage(this.lang.get("home.wait", Map.of("seconds", String.valueOf(remaining))));
            return true;
        }
        final HashMap<String, Location> homes = new HashMap<String, Location>();
        if (this.plugin.getConfig().getConfigurationSection("homes." + String.valueOf(player.getUniqueId())) != null) {
            for (String key : this.plugin.getConfig().getConfigurationSection("homes." + String.valueOf(player.getUniqueId())).getKeys(false)) {
                Location loc = this.plugin.getConfig().getLocation("homes." + String.valueOf(player.getUniqueId()) + "." + key);
                if (loc == null) continue;
                homes.put(key, loc);
            }
        }
        if (command.getName().equalsIgnoreCase("sethome")) {
            if (homes.size() >= maxHomes && !homes.containsKey(name)) {
                player.sendMessage(this.lang.get("home.max", Map.of("max", String.valueOf(maxHomes))));
                return true;
            }
            if (homes.containsKey(name)) {
                player.sendMessage(this.lang.get("home.already_exists", Map.of("home", name.isEmpty() ? "default" : name)));
                return true;
            }
            initial = player.getLocation();
            player.sendMessage(this.lang.get("home.stand_set", Map.of("seconds", String.valueOf(standTime), "home", name.isEmpty() ? "default" : name)));
            new BukkitRunnable(){
                int seconds;
                {
                    this.seconds = standTime;
                }

                public void run() {
                    if (!player.isOnline() || !player.getLocation().getBlock().getLocation().equals((Object)initial.getBlock().getLocation())) {
                        player.sendMessage(Home.this.lang.get("home.canceled_set"));
                        this.cancel();
                        return;
                    }
                    if (this.seconds <= 0) {
                        homes.put(name, player.getLocation());
                        Home.this.plugin.getHomesConfig().set("homes." + String.valueOf(player.getUniqueId()) + "." + name, (Object)player.getLocation());
                        Home.this.plugin.saveHomesConfig();
                        player.sendMessage(Home.this.lang.get("home.set", Map.of("home", name.isEmpty() ? "default" : name)));
                        Home.this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
                        this.cancel();
                    }
                    --this.seconds;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        } else if (command.getName().equalsIgnoreCase("home")) {
            if (!homes.containsKey(name)) {
                player.sendMessage(this.lang.get("home.missing", Map.of("home", name.isEmpty() ? "default" : name)));
                return true;
            }
            initial = player.getLocation();
            player.sendMessage(this.lang.get("home.stand_tp", Map.of("seconds", String.valueOf(standTime), "home", name.isEmpty() ? "default" : name)));
            new BukkitRunnable(){
                int seconds;
                {
                    this.seconds = standTime;
                }

                public void run() {
                    if (!player.isOnline() || !player.getLocation().getBlock().getLocation().equals((Object)initial.getBlock().getLocation())) {
                        player.sendMessage(Home.this.lang.get("home.canceled"));
                        this.cancel();
                        return;
                    }
                    if (this.seconds <= 0) {
                        player.teleport((Location)homes.get(name));
                        player.sendMessage(Home.this.lang.get("home.tp", Map.of("home", name.isEmpty() ? "default" : name)));
                        Home.this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
                        this.cancel();
                    }
                    --this.seconds;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        }
        return true;
    }
}

