/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Mute
implements CommandExecutor {
    private final EssentiaX plugin;
    private final Language lang;
    private final Map<UUID, Long> muted = new HashMap<UUID, Long>();
    private final Map<UUID, Long> fullMuted = new HashMap<UUID, Long>();

    public Mute(EssentiaX plugin, Language lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    public boolean isMuted(UUID sender, UUID receiver) {
        if (!this.muted.containsKey(sender)) {
            return false;
        }
        long end = this.muted.get(sender);
        if (end == Long.MAX_VALUE) {
            return true;
        }
        if (System.currentTimeMillis() > end) {
            this.muted.remove(sender);
            return false;
        }
        return true;
    }

    public boolean isFullMuted(UUID sender) {
        if (!this.fullMuted.containsKey(sender)) {
            return false;
        }
        long end = this.fullMuted.get(sender);
        if (end == Long.MAX_VALUE) {
            return true;
        }
        if (System.currentTimeMillis() > end) {
            this.fullMuted.remove(sender);
            return false;
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmdName = command.getName().toLowerCase();
        if (cmdName.equals("mute") || cmdName.equals("fullmute") || cmdName.equals("fmute")) {
            long duration;
            boolean isFull;
            boolean bl = isFull = cmdName.equals("fullmute") || cmdName.equals("fmute");
            if (isFull && !this.plugin.getConfig().getBoolean("fullmute.enabled", true)) {
                sender.sendMessage(this.lang.get("mute.disabled"));
                return true;
            }
            if (!sender.hasPermission("essentia.mute")) {
                return true;
            }
            if (args.length != 2) {
                sender.sendMessage(this.lang.get("mute.usage_mute"));
                return true;
            }
            final Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(this.lang.get("mute.not_found"));
                return true;
            }
            if (args[1].equalsIgnoreCase("infinite")) {
                duration = Long.MAX_VALUE;
            } else {
                try {
                    duration = Long.parseLong(args[1]) * 1000L;
                    if (duration <= 0L) {
                        throw new NumberFormatException();
                    }
                    duration += System.currentTimeMillis();
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.lang.get("mute.invalid_time"));
                    return true;
                }
            }
            if (isFull) {
                this.fullMuted.put(target.getUniqueId(), duration);
            } else {
                this.muted.put(target.getUniqueId(), duration);
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", target.getName());
            sender.sendMessage(this.lang.get("mute.muted", placeholders));
            if (duration != Long.MAX_VALUE) {
                long finalDuration = duration;
                new BukkitRunnable(){

                    public void run() {
                        if (isFull) {
                            Mute.this.fullMuted.remove(target.getUniqueId());
                        } else {
                            Mute.this.muted.remove(target.getUniqueId());
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, (finalDuration - System.currentTimeMillis()) / 50L);
            }
            return true;
        }
        if (cmdName.equals("unmute")) {
            if (args.length != 1) {
                sender.sendMessage(this.lang.get("mute.usage_unmute"));
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(this.lang.get("mute.not_found"));
                return true;
            }
            boolean removed = this.muted.remove(target.getUniqueId()) != null;
            boolean fullRemoved = this.fullMuted.remove(target.getUniqueId()) != null;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", target.getName());
            if (removed || fullRemoved) {
                sender.sendMessage(this.lang.get("mute.unmuted", placeholders));
            } else {
                sender.sendMessage(this.lang.get("mute.not_muted", placeholders));
            }
            return true;
        }
        return true;
    }
}

