/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpawnPoint
implements Listener {
    private final JavaPlugin plugin;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private Location spawnLocation;
    private final boolean enabled;
    private final int cooldown;
    private final int standStillTime;
    private FileConfiguration spawnConfig;
    private File spawnFile;

    public SpawnPoint(JavaPlugin plugin) {
        this.plugin = plugin;
        this.enabled = plugin.getConfig().getBoolean("spawnpoint.enabled", true);
        this.cooldown = plugin.getConfig().getInt("spawnpoint.cooldown", 0);
        this.standStillTime = plugin.getConfig().getInt("spawnpoint.stand-still-time", 5);
        this.createSpawnFile();
        this.loadSpawn();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    private void createSpawnFile() {
        this.spawnFile = new File(this.plugin.getDataFolder(), "spawnpoints.yml");
        if (!this.spawnFile.exists()) {
            this.spawnFile.getParentFile().mkdirs();
            try {
                this.spawnFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.spawnConfig = YamlConfiguration.loadConfiguration((File)this.spawnFile);
    }

    private void saveSpawnFile() {
        try {
            this.spawnConfig.save(this.spawnFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadSpawn() {
        if (!this.spawnConfig.contains("spawnpoint.location")) {
            return;
        }
        String worldName = this.spawnConfig.getString("spawnpoint.location.world");
        double x = this.spawnConfig.getDouble("spawnpoint.location.x");
        double y = this.spawnConfig.getDouble("spawnpoint.location.y");
        double z = this.spawnConfig.getDouble("spawnpoint.location.z");
        float yaw = (float)this.spawnConfig.getDouble("spawnpoint.location.yaw");
        float pitch = (float)this.spawnConfig.getDouble("spawnpoint.location.pitch");
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            this.spawnLocation = new Location(world, x, y, z, yaw, pitch);
        }
    }

    public boolean setSpawn(Player player) {
        long lastUse;
        if (!this.enabled) {
            return false;
        }
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(uuid) && now - (lastUse = this.cooldowns.get(uuid).longValue()) < (long)this.cooldown * 1000L) {
            long remaining = ((long)this.cooldown * 1000L - (now - lastUse)) / 1000L;
            player.sendMessage("\u00a7cDu musst noch " + remaining + " Sekunden warten, bevor du den Spawnpunkt erneut setzt.");
            return false;
        }
        this.spawnLocation = player.getLocation();
        this.saveSpawn(player);
        this.cooldowns.put(uuid, now);
        player.sendMessage("\u00a7aSpawnpunkt gesetzt!");
        return true;
    }

    private void saveSpawn(Player player) {
        this.spawnConfig.set("spawnpoint.location.world", (Object)this.spawnLocation.getWorld().getName());
        this.spawnConfig.set("spawnpoint.location.x", (Object)this.spawnLocation.getX());
        this.spawnConfig.set("spawnpoint.location.y", (Object)this.spawnLocation.getY());
        this.spawnConfig.set("spawnpoint.location.z", (Object)this.spawnLocation.getZ());
        this.spawnConfig.set("spawnpoint.location.yaw", (Object)Float.valueOf(this.spawnLocation.getYaw()));
        this.spawnConfig.set("spawnpoint.location.pitch", (Object)Float.valueOf(this.spawnLocation.getPitch()));
        this.saveSpawnFile();
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.enabled || this.spawnLocation == null) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> event.setRespawnLocation(this.spawnLocation), (long)this.standStillTime * 20L);
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }
}

