/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.ConfigHelper;
import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Tpa
implements CommandExecutor {
    private final EssentiaX plugin;
    private final Language lang;
    private final Map<UUID, UUID> requests = new HashMap<UUID, UUID>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public Tpa(EssentiaX plugin, Language lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    private boolean hasPermission(Player player, String permission) {
        return player.hasPermission("essentia.tp.*") || player.hasPermission(permission);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long remaining;
        if (!(sender instanceof Player)) {
            return true;
        }
        final Player player = (Player)sender;
        final int standTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "tpa.stand-still-time", 5);
        int cooldownTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "tpa.cooldown", 0);
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(player.getUniqueId()) && (remaining = (this.cooldowns.get(player.getUniqueId()) + (long)cooldownTime * 1000L - now) / 1000L) > 0L) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("seconds", String.valueOf(remaining));
            player.sendMessage(this.lang.get("tpa.cooldown", placeholders));
            return true;
        }
        if (command.getName().equalsIgnoreCase("tpa")) {
            if (!this.hasPermission(player, "essentia.tpa")) {
                return true;
            }
            if (args.length != 1) {
                player.sendMessage(this.lang.get("tpa.usage", new HashMap<String, String>()));
                return true;
            }
            final Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", args[0]);
                player.sendMessage(this.lang.get("tpa.not_found", placeholders));
                return true;
            }
            this.requests.put(target.getUniqueId(), player.getUniqueId());
            HashMap<String, String> placeholdersSender = new HashMap<String, String>();
            placeholdersSender.put("player", target.getName());
            player.sendMessage(this.lang.get("tpa.sent", placeholdersSender));
            HashMap<String, String> placeholdersTarget = new HashMap<String, String>();
            placeholdersTarget.put("player", player.getName());
            target.sendMessage(this.lang.get("tpa.receive", placeholdersTarget));
            new BukkitRunnable(){

                public void run() {
                    if (Tpa.this.requests.get(target.getUniqueId()) != null && ((UUID)Tpa.this.requests.get(target.getUniqueId())).equals(player.getUniqueId())) {
                        Tpa.this.requests.remove(target.getUniqueId());
                        HashMap<String, String> senderMap = new HashMap<String, String>();
                        senderMap.put("player", target.getName());
                        player.sendMessage(Tpa.this.lang.get("tpa.expired_sender", senderMap));
                        HashMap<String, String> targetMap = new HashMap<String, String>();
                        targetMap.put("player", player.getName());
                        target.sendMessage(Tpa.this.lang.get("tpa.expired_target", targetMap));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 600L);
        } else if (command.getName().equalsIgnoreCase("tpaccept")) {
            if (!this.hasPermission(player, "essentia.tpaccept")) {
                return true;
            }
            UUID requesterUUID = this.requests.remove(player.getUniqueId());
            if (requesterUUID == null) {
                player.sendMessage(this.lang.get("tpa.no_request", new HashMap<String, String>()));
                return true;
            }
            final Player requester = Bukkit.getPlayer((UUID)requesterUUID);
            if (requester == null || !requester.isOnline()) {
                player.sendMessage(this.lang.get("tpa.offline", new HashMap<String, String>()));
                return true;
            }
            final Location initial = requester.getLocation();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("seconds", String.valueOf(standTime));
            player.sendMessage(this.lang.get("tpa.stand", placeholders));
            new BukkitRunnable(){
                int seconds;
                {
                    this.seconds = standTime;
                }

                public void run() {
                    if (!requester.isOnline() || !requester.getLocation().getBlock().getLocation().equals((Object)initial.getBlock().getLocation())) {
                        player.sendMessage(Tpa.this.lang.get("tpa.canceled", new HashMap<String, String>()));
                        this.cancel();
                        return;
                    }
                    if (this.seconds <= 0) {
                        requester.teleport(player.getLocation());
                        HashMap<String, String> tpMap = new HashMap<String, String>();
                        tpMap.put("player", player.getName());
                        requester.sendMessage(Tpa.this.lang.get("tpa.tp", tpMap));
                        HashMap<String, String> acceptMap = new HashMap<String, String>();
                        acceptMap.put("player", requester.getName());
                        player.sendMessage(Tpa.this.lang.get("tpa.accept", acceptMap));
                        Tpa.this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
                        this.cancel();
                    }
                    --this.seconds;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        } else if (command.getName().equalsIgnoreCase("tpdeny")) {
            if (!this.hasPermission(player, "essentia.tpdeny")) {
                return true;
            }
            UUID requesterUUID = this.requests.remove(player.getUniqueId());
            if (requesterUUID == null) {
                player.sendMessage(this.lang.get("tpa.no_request", new HashMap<String, String>()));
                return true;
            }
            Player requester = Bukkit.getPlayer((UUID)requesterUUID);
            if (requester != null && requester.isOnline()) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", player.getName());
                requester.sendMessage(this.lang.get("tpa.denied_sender", placeholders));
            }
            HashMap<String, String> playerMap = new HashMap<String, String>();
            playerMap.put("player", requester != null ? requester.getName() : "unknown");
            player.sendMessage(this.lang.get("tpa.deny", playerMap));
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
        return true;
    }
}

