/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy;

import de.scholle.essentiax.EssentiaX;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EssentiaXEconomy {
    private final EssentiaX plugin;
    private final File extrasFile;
    private final FileConfiguration extrasConfig;
    private final File economyFile;
    private final FileConfiguration economyConfig;
    private boolean useVault;
    private boolean economyEnabled;
    private Economy vault;

    public EssentiaXEconomy(EssentiaX plugin) {
        this.plugin = plugin;
        this.extrasFile = new File(plugin.getDataFolder(), "extras.yml");
        if (!this.extrasFile.exists()) {
            plugin.saveResource("extras.yml", false);
        }
        this.extrasConfig = YamlConfiguration.loadConfiguration((File)this.extrasFile);
        this.economyFile = new File(plugin.getDataFolder(), "extras/economy.yml");
        if (!this.economyFile.exists()) {
            this.economyFile.getParentFile().mkdirs();
            try {
                this.economyFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.economyConfig = YamlConfiguration.loadConfiguration((File)this.economyFile);
        this.economyEnabled = this.extrasConfig.getBoolean("economy.enabled", true);
        this.useVault = this.extrasConfig.getBoolean("economy.vault-enabled", false);
        if (this.useVault && this.economyEnabled) {
            if (plugin.getServer().getPluginManager().getPlugin("Vault") != null) {
                RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
                if (rsp != null) {
                    this.vault = (Economy)rsp.getProvider();
                } else {
                    this.useVault = false;
                }
            } else {
                this.useVault = false;
            }
        }
    }

    public boolean isEnabled() {
        return this.economyEnabled;
    }

    public double getBalance(OfflinePlayer player) {
        if (!this.economyEnabled) {
            return 0.0;
        }
        if (this.useVault && this.vault != null) {
            return this.vault.getBalance(player);
        }
        double startBalance = this.extrasConfig.getDouble("economy.start-balance", 100.0);
        return this.economyConfig.getDouble("players." + player.getUniqueId(), startBalance);
    }

    public void setBalance(OfflinePlayer player, double amount) {
        if (!this.economyEnabled) {
            return;
        }
        if (this.useVault && this.vault != null) {
            double bal = this.getBalance(player);
            if (amount > bal) {
                this.vault.depositPlayer(player, amount - bal);
            } else if (amount < bal) {
                this.vault.withdrawPlayer(player, bal - amount);
            }
            return;
        }
        this.economyConfig.set("players." + player.getUniqueId(), (Object)amount);
        this.saveEconomy();
    }

    public void addBalance(OfflinePlayer player, double amount) {
        if (!this.economyEnabled) {
            return;
        }
        if (this.useVault && this.vault != null) {
            this.vault.depositPlayer(player, amount);
            return;
        }
        this.setBalance(player, this.getBalance(player) + amount);
    }

    public void removeBalance(OfflinePlayer player, double amount) {
        if (!this.economyEnabled) {
            return;
        }
        if (this.useVault && this.vault != null) {
            this.vault.withdrawPlayer(player, amount);
            return;
        }
        this.setBalance(player, Math.max(0.0, this.getBalance(player) - amount));
    }

    public String format(double amount) {
        if (!this.economyEnabled) {
            return this.extrasConfig.getString("economy.currency-symbol", "$") + "0";
        }
        if (this.useVault && this.vault != null) {
            return this.vault.format(amount);
        }
        return this.extrasConfig.getString("economy.currency-symbol", "$") + amount;
    }

    private void saveEconomy() {
        try {
            this.economyConfig.save(this.economyFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Set<OfflinePlayer> getAllPlayers() {
        if (!this.economyEnabled) {
            return Set.of();
        }
        if (this.useVault && this.vault != null) {
            return Set.of();
        }
        if (!this.economyConfig.contains("players")) {
            return Set.of();
        }
        return this.economyConfig.getConfigurationSection("players").getKeys(false).stream().map(UUID::fromString).map(uuid -> this.plugin.getServer().getOfflinePlayer(uuid)).collect(Collectors.toSet());
    }

    public FileConfiguration getExtrasConfig() {
        return this.extrasConfig;
    }
}

