/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class AdminWarp
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final Map<Player, Location> lastLocation = new HashMap<Player, Location>();
    private final Map<Player, GameMode> lastGameMode = new HashMap<Player, GameMode>();

    public AdminWarp(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("essentia.adminwarp")) {
            return true;
        }
        if (command.getName().equalsIgnoreCase("adminwarp") || command.getName().equalsIgnoreCase("aw")) {
            if (args.length < 1 || args.length > 2) {
                player.sendMessage("\u00a7eUsage: /adminwarp <player> [v|vanish]");
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendMessage("\u00a7cPlayer not found or not online.");
                return true;
            }
            boolean vanishMode = args.length == 2 && (args[1].equalsIgnoreCase("v") || args[1].equalsIgnoreCase("vanish"));
            this.lastLocation.put(player, player.getLocation());
            this.lastGameMode.put(player, player.getGameMode());
            player.teleport(target.getLocation());
            if (vanishMode) {
                player.setGameMode(GameMode.SPECTATOR);
                player.sendMessage("\u00a7aStealth teleportiert zu " + target.getName() + " (Spectator)!");
            } else {
                player.sendMessage("\u00a7aTeleported to " + target.getName() + "!");
            }
        } else if (command.getName().equalsIgnoreCase("adminwarpback") || command.getName().equalsIgnoreCase("awb")) {
            if (!this.lastLocation.containsKey(player)) {
                player.sendMessage("\u00a7cNo previous location stored.");
                return true;
            }
            player.teleport(this.lastLocation.get(player));
            if (this.lastGameMode.containsKey(player)) {
                player.setGameMode(this.lastGameMode.get(player));
                this.lastGameMode.remove(player);
            } else {
                player.setGameMode(GameMode.SURVIVAL);
            }
            player.sendMessage("\u00a7aTeleported back to your previous location!");
            this.lastLocation.remove(player);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return completions;
        }
        if (command.getName().equalsIgnoreCase("adminwarp") || command.getName().equalsIgnoreCase("aw")) {
            if (args.length == 1) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!p.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    completions.add(p.getName());
                }
            } else if (args.length == 2) {
                if ("vanish".startsWith(args[1].toLowerCase())) {
                    completions.add("vanish");
                }
                if ("v".startsWith(args[1].toLowerCase())) {
                    completions.add("v");
                }
            }
        }
        return completions;
    }
}

