/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.ConfigHelper;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Despawn {
    private final JavaPlugin plugin;

    public Despawn(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.startDespawnTask();
    }

    private void startDespawnTask() {
        final boolean itemEnabled = ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "despawn.items.enabled", true);
        final boolean xpEnabled = ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "despawn.xp.enabled", true);
        final int itemTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "despawn.items.time", 300);
        final int xpTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "despawn.xp.time", 300);
        new BukkitRunnable(this){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        ExperienceOrb xp;
                        if (itemEnabled && entity instanceof Item) {
                            Item item = (Item)entity;
                            if ((long)item.getTicksLived() * 50L < (long)itemTime * 1000L) continue;
                            item.remove();
                            continue;
                        }
                        if (!xpEnabled || !(entity instanceof ExperienceOrb) || (long)(xp = (ExperienceOrb)entity).getTicksLived() * 50L < (long)xpTime * 1000L) continue;
                        xp.remove();
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }
}

