/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.ConfigHelper;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TimeVote
implements CommandExecutor {
    private final JavaPlugin plugin;
    private Set<Player> voters = new HashSet<Player>();
    private int voteYes = 0;
    private boolean voteActive = false;
    private String targetTime;
    private int voteDuration;
    private int votePercent;

    public TimeVote(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "day": {
                return this.startVote(player, "day");
            }
            case "noon": {
                return this.startVote(player, "noon");
            }
            case "morning": {
                return this.startVote(player, "morning");
            }
            case "night": {
                return this.startVote(player, "night");
            }
            case "vote": {
                if (!this.voteActive) {
                    player.sendMessage("\u00a7cThere is no active time vote.");
                    return true;
                }
                if (this.voters.contains(player)) {
                    player.sendMessage("\u00a7cYou have already voted.");
                    return true;
                }
                ++this.voteYes;
                this.voters.add(player);
                player.sendMessage("\u00a7aYou voted to approve the time change!");
                return true;
            }
        }
        return false;
    }

    private boolean startVote(Player player, String time) {
        if (this.voteActive) {
            player.sendMessage("\u00a7cThere is already a time vote in progress.");
            return true;
        }
        boolean enabled = ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "timevote." + time + ".enabled", true);
        if (!enabled) {
            player.sendMessage("\u00a7cThis time change is disabled on this server.");
            return true;
        }
        if (!player.hasPermission("essentia." + time) && !player.hasPermission("essentia.time.*")) {
            player.sendMessage("\u00a7cYou do not have permission to start this time vote.");
            return true;
        }
        this.voteActive = true;
        this.targetTime = time;
        this.voters.clear();
        this.voteYes = 1;
        this.voters.add(player);
        this.voteDuration = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "timevote.duration", 60);
        this.votePercent = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "timevote.percent", 50);
        Bukkit.broadcastMessage((String)("\u00a7e" + player.getName() + " wants to make it " + time + "! Use /vote to accept."));
        new BukkitRunnable(){
            int seconds;
            {
                this.seconds = TimeVote.this.voteDuration;
            }

            public void run() {
                if (this.seconds-- <= 0) {
                    int online = Bukkit.getOnlinePlayers().size();
                    if (TimeVote.this.voteYes * 100 / online >= TimeVote.this.votePercent) {
                        TimeVote.this.setTime(TimeVote.this.targetTime);
                        Bukkit.broadcastMessage((String)("\u00a7aTime has been changed to " + TimeVote.this.targetTime + "!"));
                    } else {
                        Bukkit.broadcastMessage((String)("\u00a7cTime change to " + TimeVote.this.targetTime + " failed."));
                    }
                    TimeVote.this.voteActive = false;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
        return true;
    }

    private void setTime(String time) {
        long ticks = switch (time) {
            case "day" -> 1000L;
            case "noon" -> 6000L;
            case "morning" -> 0L;
            case "night" -> 13000L;
            default -> 1000L;
        };
        for (World world : Bukkit.getWorlds()) {
            world.setTime(ticks);
        }
    }
}

