/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.Update;
import de.scholle.essentiax.core.AFK;
import de.scholle.essentiax.core.AFKSpot;
import de.scholle.essentiax.core.AdminWarp;
import de.scholle.essentiax.core.Announcement;
import de.scholle.essentiax.core.Back;
import de.scholle.essentiax.core.GameModeCommand;
import de.scholle.essentiax.core.Home;
import de.scholle.essentiax.core.Language;
import de.scholle.essentiax.core.Msg;
import de.scholle.essentiax.core.Mute;
import de.scholle.essentiax.core.RTP;
import de.scholle.essentiax.core.Reply;
import de.scholle.essentiax.core.Spawn;
import de.scholle.essentiax.core.SpawnPoint;
import de.scholle.essentiax.core.Tpa;
import de.scholle.essentiax.core.Vanish;
import de.scholle.essentiax.extras.Chat;
import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentiaX
extends JavaPlugin {
    private Language language;
    private FileConfiguration homesConfig;
    private File homesFile;
    private FileConfiguration extrasConfig;
    private File extrasFile;
    private Chat chat;
    private BetterEconomy economy;

    public void onEnable() {
        this.saveDefaultConfig();
        String langCode = this.getConfig().getString("language", "en_us");
        this.language = new Language(langCode);
        this.createHomesFile();
        this.loadExtrasConfig();
        this.economy = new BetterEconomy();
        this.economy.onLoad();
        this.economy.load();
        this.economy.enable();
        EconomyHolder holder = (EconomyHolder)((Object)this.economy.get(EconomyHolder.class));
        if (holder != null) {
            holder.load();
        }
        this.getCommand("spawn").setExecutor((CommandExecutor)new Spawn(this, this.language));
        Home home = new Home(this, this.language);
        this.getCommand("sethome").setExecutor((CommandExecutor)home);
        this.getCommand("home").setExecutor((CommandExecutor)home);
        Tpa tpa = new Tpa(this, this.language);
        this.getCommand("tpa").setExecutor((CommandExecutor)tpa);
        this.getCommand("tpaccept").setExecutor((CommandExecutor)tpa);
        this.getCommand("tpdeny").setExecutor((CommandExecutor)tpa);
        Back back = new Back(this, this.language);
        this.getCommand("back").setExecutor((CommandExecutor)back);
        Mute mute = new Mute(this, this.language);
        this.getCommand("mute").setExecutor((CommandExecutor)mute);
        this.getCommand("unmute").setExecutor((CommandExecutor)mute);
        Reply reply = new Reply(this, mute, this.language);
        Msg msg = new Msg(this, reply, mute, this.language);
        this.getCommand("msg").setExecutor((CommandExecutor)msg);
        this.getCommand("msg").setTabCompleter((TabCompleter)msg);
        this.getCommand("reply").setExecutor((CommandExecutor)reply);
        this.getCommand("reply").setTabCompleter((TabCompleter)reply);
        GameModeCommand gmCommand = new GameModeCommand();
        this.getCommand("gamemode").setExecutor((CommandExecutor)gmCommand);
        this.getCommand("gm").setExecutor((CommandExecutor)gmCommand);
        AFK afk = new AFK(this, this.language);
        this.getCommand("afk").setExecutor((CommandExecutor)afk);
        this.getCommand("afkspot").setExecutor((CommandExecutor)new AFKSpot(this, afk, this.language));
        AdminWarp adminWarp = new AdminWarp(this);
        this.getCommand("adminwarp").setExecutor((CommandExecutor)adminWarp);
        this.getCommand("adminwarpback").setExecutor((CommandExecutor)adminWarp);
        this.chat = new Chat(this);
        this.getCommand("clearchat").setExecutor((CommandExecutor)this.chat);
        new Announcement(this);
        new Update(this).checkForUpdates();
        this.getCommand("rtp").setExecutor((CommandExecutor)new RTP(this));
        if (this.getConfig().getBoolean("vanish.enabled", true)) {
            Vanish vanish = new Vanish(this, this.language);
            this.getCommand("vanish").setExecutor((CommandExecutor)vanish);
            this.getCommand("v").setExecutor((CommandExecutor)vanish);
        }
        SpawnPoint spawnPoint = new SpawnPoint(this);
        this.getCommand("spawnpoint").setExecutor((sender, command, label, args) -> {
            if (!(sender instanceof Player)) {
                return true;
            }
            Player player = (Player)sender;
            spawnPoint.setSpawn(player);
            return true;
        });
        this.getLogger().info("EssentiaX has been successfully enabled!");
    }

    public void createHomesFile() {
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            this.homesFile.getParentFile().mkdirs();
            this.saveResource("homes.yml", false);
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    public FileConfiguration getHomesConfig() {
        return this.homesConfig;
    }

    public void saveHomesConfig() {
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadExtrasConfig() {
        this.extrasFile = new File(this.getDataFolder(), "extras.yml");
        if (!this.extrasFile.exists()) {
            this.saveResource("extras.yml", false);
        }
        this.extrasConfig = YamlConfiguration.loadConfiguration((File)this.extrasFile);
    }

    public FileConfiguration getExtrasConfig() {
        return this.extrasConfig;
    }
}

