/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.core.Language;
import de.scholle.essentiax.core.Mute;
import de.scholle.essentiax.core.Reply;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Msg
implements CommandExecutor,
TabCompleter {
    private final EssentiaX plugin;
    private final Reply reply;
    private final Mute mute;
    private final Language lang;

    public Msg(EssentiaX plugin, Reply reply, Mute mute, Language lang) {
        this.plugin = plugin;
        this.reply = reply;
        this.mute = mute;
        this.lang = lang;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfig().getBoolean("msg.enabled", true)) {
            player.sendMessage(this.lang.get("msg.disabled"));
            return true;
        }
        if (!player.hasPermission("essentia.msg")) {
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(this.lang.get("msg.usage"));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(this.lang.get("msg.offline"));
            return true;
        }
        if (this.plugin.getConfig().getBoolean("mute.enabled", true) && this.mute.isMuted(player.getUniqueId(), target.getUniqueId())) {
            return true;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        target.sendMessage(this.lang.get("msg.from", Map.of("player", player.getName(), "message", message)));
        player.sendMessage(this.lang.get("msg.to", Map.of("player", target.getName(), "message", message)));
        this.reply.setLastMessaged(player, target);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            String prefix = args[0].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(prefix)) continue;
                suggestions.add(p.getName());
            }
            return suggestions;
        }
        return Collections.emptyList();
    }
}

