/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.core.ConfigHelper;
import de.scholle.essentiax.core.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Spawn
implements CommandExecutor {
    private final EssentiaX plugin;
    private final Language lang;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public Spawn(EssentiaX plugin, Language lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long remaining;
        if (!(sender instanceof Player)) {
            return true;
        }
        final Player player = (Player)sender;
        if (!player.hasPermission("essentia.spawn")) {
            return true;
        }
        if (!ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "spawn.enabled", true)) {
            return true;
        }
        int cooldown = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "spawn.cooldown", 0);
        final int standTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "spawn.stand-still-time", 5);
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(player.getUniqueId()) && (remaining = (this.cooldowns.get(player.getUniqueId()) + (long)cooldown * 1000L - now) / 1000L) > 0L) {
            player.sendMessage(this.lang.get("spawn.wait", Map.of("seconds", String.valueOf(remaining))));
            return true;
        }
        final Location initial = player.getLocation();
        player.sendMessage(this.lang.get("spawn.stand", Map.of("seconds", String.valueOf(standTime))));
        new BukkitRunnable(){
            int seconds;
            {
                this.seconds = standTime;
            }

            public void run() {
                if (!player.isOnline() || !player.getLocation().getBlock().getLocation().equals((Object)initial.getBlock().getLocation())) {
                    player.sendMessage(Spawn.this.lang.get("spawn.canceled"));
                    this.cancel();
                    return;
                }
                if (this.seconds <= 0) {
                    World world = player.getWorld();
                    player.teleport(world.getSpawnLocation());
                    player.sendMessage(Spawn.this.lang.get("spawn.teleported"));
                    Spawn.this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
                    this.cancel();
                }
                --this.seconds;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }
}

