/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.command;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.Permissions;
import de.scholle.essentiax.extras.economy.Utils;
import de.scholle.essentiax.extras.economy.config.MainConfig;
import de.scholle.essentiax.extras.economy.config.MessageConfig;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import java.util.Collections;
import java.util.UUID;
import me.hsgamer.hscore.bukkit.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BalanceCommand
extends Command {
    private final BetterEconomy instance;

    public BalanceCommand(BetterEconomy instance) {
        super("balance", "Get the balance of a player", "/balance [player]", Collections.singletonList("bal"));
        this.instance = instance;
        this.setPermission(Permissions.BALANCE.getName());
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        UUID uuid;
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length > 0 && sender.hasPermission(Permissions.BALANCE_OTHERS)) {
            uuid = Utils.getUniqueId(args[0]);
        } else if (sender instanceof Player) {
            uuid = ((Player)sender).getUniqueId();
        } else {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getPlayerOnly());
            return false;
        }
        if (!((EconomyHolder)((Object)this.instance.get(EconomyHolder.class))).hasAccount(uuid)) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getPlayerNotFound());
            return false;
        }
        MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getBalanceOutput().replace("{balance}", ((MainConfig)this.instance.get(MainConfig.class)).format(((EconomyHolder)((Object)this.instance.get(EconomyHolder.class))).get(uuid))));
        return true;
    }
}

