/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.command;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.Permissions;
import de.scholle.essentiax.extras.economy.Utils;
import de.scholle.essentiax.extras.economy.config.MainConfig;
import de.scholle.essentiax.extras.economy.config.MessageConfig;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.hscore.bukkit.utils.MessageUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class BalanceTopCommand
extends Command {
    private final BetterEconomy instance;

    public BalanceTopCommand(BetterEconomy instance) {
        super("balancetop", "Show the balance top", "/balancetop [page]", Collections.singletonList("baltop"));
        this.instance = instance;
        this.setPermission(Permissions.BALANCE_TOP.getName());
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        List list = ((EconomyHolder)((Object)this.instance.get(EconomyHolder.class))).getSnapshotAgent().getSnapshot();
        int page = 0;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list.isEmpty()) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getEmptyBalanceTop());
            return true;
        }
        int startIndex = 10 * page % list.size();
        int endIndex = Math.min(list.size(), startIndex + 10);
        for (int index = startIndex; index < endIndex; ++index) {
            Map.Entry snapshot = (Map.Entry)list.get(index);
            OfflinePlayer offlinePlayer = Utils.getOfflinePlayer((UUID)snapshot.getKey());
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getBalanceTopOutput().replace("{place}", Integer.toString(index + 1)).replace("{name}", Optional.ofNullable(offlinePlayer.getName()).orElse(Utils.getUniqueId(offlinePlayer).toString())).replace("{balance}", ((MainConfig)this.instance.get(MainConfig.class)).format((Double)snapshot.getValue())));
        }
        return true;
    }
}

