/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.command;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.Permissions;
import de.scholle.essentiax.extras.economy.command.sub.GiveSubCommand;
import de.scholle.essentiax.extras.economy.command.sub.ReloadSubCommand;
import de.scholle.essentiax.extras.economy.command.sub.SetSubCommand;
import de.scholle.essentiax.extras.economy.command.sub.TakeSubCommand;
import io.github.projectunified.minelib.util.subcommand.SubCommand;
import io.github.projectunified.minelib.util.subcommand.SubCommandManager;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class MainCommand
extends Command {
    private final SubCommandManager subCommandManager = new SubCommandManager(){

        public void sendHelpMessage(@NotNull CommandSender sender, @NotNull String label, String ... args) {
            if (sender.hasPermission(Permissions.ADMIN)) {
                super.sendHelpMessage(sender, label, args);
            }
            this.sendCommand(sender, "/balancetop", "Show the balance top");
            this.sendCommand(sender, "/balance", "Get the balance of a player");
        }

        private void sendCommand(CommandSender sender, String usage, String description) {
            sender.sendMessage(ChatColor.YELLOW + usage);
            sender.sendMessage(ChatColor.WHITE + "  " + description);
        }
    };

    public MainCommand(BetterEconomy instance) {
        super(instance.getName().toLowerCase(Locale.ROOT), "Main Command", "/" + instance.getName().toLowerCase(Locale.ROOT), Collections.singletonList("eco"));
        this.subCommandManager.registerSubcommand((SubCommand)new GiveSubCommand(instance));
        this.subCommandManager.registerSubcommand((SubCommand)new TakeSubCommand(instance));
        this.subCommandManager.registerSubcommand((SubCommand)new SetSubCommand(instance));
        this.subCommandManager.registerSubcommand((SubCommand)new ReloadSubCommand(instance));
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        return this.subCommandManager.onCommand(sender, commandLabel, args);
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        return this.subCommandManager.onTabComplete(sender, alias, args);
    }
}

