/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.command;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.Permissions;
import de.scholle.essentiax.extras.economy.Utils;
import de.scholle.essentiax.extras.economy.config.MainConfig;
import de.scholle.essentiax.extras.economy.config.MessageConfig;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.hscore.bukkit.utils.MessageUtils;
import me.hsgamer.hscore.common.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PayCommand
extends Command {
    private final BetterEconomy instance;

    public PayCommand(BetterEconomy instance) {
        super("pay", "Transfer money to the player", "/pay <player> <amount>", Collections.emptyList());
        this.instance = instance;
        this.setPermission(Permissions.PAY.getName());
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length < 2) {
            MessageUtils.sendMessage((CommandSender)sender, (String)this.getUsage());
            return false;
        }
        if (!(sender instanceof Player)) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getPlayerOnly());
            return false;
        }
        EconomyHolder holder = (EconomyHolder)((Object)this.instance.get(EconomyHolder.class));
        Player player = (Player)sender;
        OfflinePlayer receiver = Utils.getOfflinePlayer(args[0]);
        if (receiver == player) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getCannotDo());
            return false;
        }
        UUID playerUUID = Utils.getUniqueId((OfflinePlayer)player);
        UUID receiverUUID = Utils.getUniqueId(receiver);
        if (!holder.hasAccount(playerUUID) || !holder.hasAccount(receiverUUID)) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getPlayerNotFound());
            return false;
        }
        Optional<Double> optionalAmount = Validate.getNumber((String)args[1]).map(BigDecimal::doubleValue).filter(value -> value > 0.0).filter(value -> holder.has(playerUUID, (double)value));
        if (!optionalAmount.isPresent()) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getInvalidAmount());
            return false;
        }
        double amount = optionalAmount.get();
        holder.withdraw(playerUUID, amount);
        holder.deposit(receiverUUID, amount);
        MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getGiveSuccess().replace("{balance}", ((MainConfig)this.instance.get(MainConfig.class)).format(amount)).replace("{name}", Optional.ofNullable(receiver.getName()).orElse(receiverUUID.toString())));
        MessageUtils.sendMessage((UUID)receiverUUID, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getReceive().replace("{balance}", ((MainConfig)this.instance.get(MainConfig.class)).format(amount)).replace("{name}", player.getName()));
        return true;
    }
}

