/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.command.sub;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.Permissions;
import de.scholle.essentiax.extras.economy.Utils;
import de.scholle.essentiax.extras.economy.config.MessageConfig;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import io.github.projectunified.minelib.util.subcommand.SubCommand;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.hscore.bukkit.utils.MessageUtils;
import me.hsgamer.hscore.common.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class ChangeMoneySubCommand
extends SubCommand {
    protected final BetterEconomy instance;

    protected ChangeMoneySubCommand(BetterEconomy instance, @NotNull String name, @NotNull String description, @NotNull String usage) {
        super(name, description, usage, Permissions.ADMIN.getName(), true);
        this.instance = instance;
    }

    protected abstract boolean tryChange(CommandSender var1, OfflinePlayer var2, double var3);

    protected abstract void sendSuccessMessage(CommandSender var1, OfflinePlayer var2, double var3);

    protected abstract void sendFailMessage(CommandSender var1, OfflinePlayer var2, double var3);

    private Collection<? extends OfflinePlayer> getPlayersFromSelector(CommandSender sender, String selector) {
        if (selector.startsWith("@")) {
            switch (selector) {
                case "@a": {
                    return Bukkit.getOnlinePlayers();
                }
                case "@p": {
                    if (sender instanceof Player) {
                        return Collections.singletonList((Player)sender);
                    }
                    return Collections.emptyList();
                }
            }
        }
        return Collections.singletonList(Utils.getOfflinePlayer(selector));
    }

    public void onSubCommand(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        Optional<Double> amountOptional = Validate.getNumber((String)args[1]).map(BigDecimal::doubleValue).filter(value -> value >= 0.0);
        if (!amountOptional.isPresent()) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getInvalidAmount());
            return;
        }
        double amount = amountOptional.get();
        Collection<? extends OfflinePlayer> offlinePlayers = this.getPlayersFromSelector(sender, args[0]);
        if (offlinePlayers.isEmpty()) {
            MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getEmptyPlayerSelector());
            return;
        }
        for (OfflinePlayer offlinePlayer : offlinePlayers) {
            if (!((EconomyHolder)((Object)this.instance.get(EconomyHolder.class))).hasAccount(Utils.getUniqueId(offlinePlayer))) {
                MessageUtils.sendMessage((CommandSender)sender, (String)((MessageConfig)this.instance.get(MessageConfig.class)).getPlayerNotFound());
                return;
            }
            if (this.tryChange(sender, offlinePlayer, amount)) {
                this.sendSuccessMessage(sender, offlinePlayer, amount);
                continue;
            }
            this.sendFailMessage(sender, offlinePlayer, amount);
        }
    }

    public boolean isProperUsage(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        return args.length >= 2;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        if (args.length == 1) {
            String name = args[0].trim();
            return Stream.concat(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName), Stream.of("@a", "@p")).filter(playerName -> name.isEmpty() || playerName.startsWith(name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

