/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.config;

import de.scholle.essentiax.extras.economy.config.converter.StringObjectMapConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Map;
import me.hsgamer.hscore.config.annotation.ConfigPath;
import me.hsgamer.topper.storage.sql.core.SqlDatabaseSetting;

public interface MainConfig {
    @ConfigPath(value={"handler-type"})
    default public String getHandlerType() {
        return "file";
    }

    @ConfigPath(value={"currency", "singular"}, priority=1)
    default public String getCurrencySingular() {
        return "$";
    }

    @ConfigPath(value={"currency", "plural"}, priority=1)
    default public String getCurrencyPlural() {
        return "$";
    }

    @ConfigPath(value={"currency", "symbol"}, priority=1)
    default public String getCurrencySymbol() {
        return "$";
    }

    @ConfigPath(value={"currency", "format-fractional-digits"}, priority=1)
    default public int getFractionalDigits() {
        return 2;
    }

    @ConfigPath(value={"currency", "decimal-point"}, priority=1)
    default public String getDecimalPoint() {
        return ".";
    }

    @ConfigPath(value={"currency", "use-thousands-separator"}, priority=1)
    default public boolean isUseThousandsSeparator() {
        return true;
    }

    @ConfigPath(value={"currency", "thousands-separator"}, priority=1)
    default public String getThousandsSeparator() {
        return ",";
    }

    @ConfigPath(value={"balance", "top-update-period"}, priority=2)
    default public int getUpdateBalanceTopPeriod() {
        return 100;
    }

    @ConfigPath(value={"balance", "file-save-period"}, priority=2)
    default public int getSaveFilePeriod() {
        return 200;
    }

    @ConfigPath(value={"balance", "start-amount"}, priority=2)
    default public double getStartAmount() {
        return 0.0;
    }

    @ConfigPath(value={"balance", "min-amount"}, priority=2)
    default public double getMinimumAmount() {
        return 0.0;
    }

    @ConfigPath(value={"database", "mysql", "host"}, priority=3)
    default public String getMysqlHost() {
        return "localhost";
    }

    @ConfigPath(value={"database", "mysql", "port"}, priority=3)
    default public String getMysqlPort() {
        return "3306";
    }

    @ConfigPath(value={"database", "mysql", "dbname"}, priority=3)
    default public String getMysqlDatabaseName() {
        return "";
    }

    @ConfigPath(value={"database", "mysql", "username"}, priority=3)
    default public String getMysqlUsername() {
        return "root";
    }

    @ConfigPath(value={"database", "mysql", "password"}, priority=3)
    default public String getMysqlPassword() {
        return "";
    }

    @ConfigPath(value={"database", "mysql", "ssl"}, priority=4)
    default public boolean isMysqlSSL() {
        return false;
    }

    @ConfigPath(value={"database", "sqlite", "dbname"}, priority=3)
    default public String getSqliteDatabaseName() {
        return "balances";
    }

    @ConfigPath(value={"database", "common", "client-settings"}, converter=StringObjectMapConverter.class, priority=3)
    default public Map<String, Object> getDatabaseClientSettings() {
        return Collections.emptyMap();
    }

    @ConfigPath(value={"database", "common", "driver-settings"}, converter=StringObjectMapConverter.class, priority=3)
    default public Map<String, Object> getDatabaseDriverSettings() {
        return Collections.emptyMap();
    }

    public void reloadConfig();

    default public String format(double amount) {
        return this.format(BigDecimal.valueOf(amount), this.getFractionalDigits());
    }

    default public String format(BigDecimal amount) {
        return this.format(amount, this.getFractionalDigits());
    }

    default public String format(BigDecimal amount, int scale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.getActualDecimalPoint());
        symbols.setGroupingSeparator(this.getActualThousandsSeparator());
        DecimalFormat format = new DecimalFormat();
        format.setRoundingMode(RoundingMode.HALF_EVEN);
        format.setGroupingUsed(this.isUseThousandsSeparator());
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(scale);
        format.setDecimalFormatSymbols(symbols);
        return format.format(amount);
    }

    default public char getActualDecimalPoint() {
        String point = this.getDecimalPoint().trim();
        return point.isEmpty() ? (char)'.' : point.charAt(0);
    }

    default public char getActualThousandsSeparator() {
        String separator = this.getThousandsSeparator().trim();
        return separator.isEmpty() ? (char)',' : separator.charAt(0);
    }

    default public SqlDatabaseSetting getSqlDatabaseSetting(final boolean sqlite) {
        return new SqlDatabaseSetting(){

            public String getHost() {
                return MainConfig.this.getMysqlHost();
            }

            public String getPort() {
                return MainConfig.this.getMysqlPort();
            }

            public String getDatabase() {
                return sqlite ? MainConfig.this.getSqliteDatabaseName() : MainConfig.this.getMysqlDatabaseName();
            }

            public String getUsername() {
                return MainConfig.this.getMysqlUsername();
            }

            public String getPassword() {
                return MainConfig.this.getMysqlPassword();
            }

            public boolean isUseSSL() {
                return MainConfig.this.isMysqlSSL();
            }

            public Map<String, Object> getDriverProperties() {
                return MainConfig.this.getDatabaseDriverSettings();
            }

            public Map<String, Object> getClientProperties() {
                return MainConfig.this.getDatabaseClientSettings();
            }
        };
    }
}

