/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.holder;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.config.MainConfig;
import io.github.projectunified.minelib.plugin.base.Loadable;
import io.github.projectunified.minelib.scheduler.async.AsyncScheduler;
import io.github.projectunified.minelib.scheduler.common.scheduler.Scheduler;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import lombok.Generated;
import me.hsgamer.hscore.bukkit.config.BukkitConfig;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.gson.GsonConfig;
import me.hsgamer.hscore.database.client.sql.java.JavaSqlClient;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.agent.core.AgentHolder;
import me.hsgamer.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.agent.snapshot.SnapshotAgent;
import me.hsgamer.topper.agent.storage.StorageAgent;
import me.hsgamer.topper.data.core.DataEntry;
import me.hsgamer.topper.data.core.DataHolder;
import me.hsgamer.topper.data.simple.SimpleDataHolder;
import me.hsgamer.topper.spigot.agent.runnable.SpigotRunnableAgent;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.flat.configfile.ConfigFileDataStorage;
import me.hsgamer.topper.storage.flat.converter.NumberFlatValueConverter;
import me.hsgamer.topper.storage.flat.converter.UUIDFlatValueConverter;
import me.hsgamer.topper.storage.flat.core.FlatValueConverter;
import me.hsgamer.topper.storage.sql.converter.NumberSqlValueConverter;
import me.hsgamer.topper.storage.sql.converter.UUIDSqlValueConverter;
import me.hsgamer.topper.storage.sql.core.SqlValueConverter;
import me.hsgamer.topper.storage.sql.mysql.MySqlDataStorageSupplier;
import me.hsgamer.topper.storage.sql.sqlite.SqliteDataStorageSupplier;
import org.bukkit.plugin.Plugin;

public class EconomyHolder
extends SimpleDataHolder<UUID, Double>
implements AgentHolder<UUID, Double>,
Loadable {
    private final BetterEconomy instance;
    private final List<Agent> agents = new ArrayList<Agent>();
    private final List<DataEntryAgent<UUID, Double>> entryAgents = new ArrayList<DataEntryAgent<UUID, Double>>();
    private StorageAgent<UUID, Double> storageAgent;
    private SnapshotAgent<UUID, Double> snapshotAgent;

    public EconomyHolder(final BetterEconomy instance) {
        this.instance = instance;
        this.entryAgents.add(new DataEntryAgent<UUID, Double>(){

            public void onCreate(DataEntry<UUID, Double> entry) {
                entry.setValue((Object)((MainConfig)instance.get(MainConfig.class)).getStartAmount(), true);
            }
        });
    }

    private DataStorage<UUID, Double> getStorage() {
        String type = ((MainConfig)this.instance.get(MainConfig.class)).getHandlerType();
        UUIDFlatValueConverter keyConverter = new UUIDFlatValueConverter();
        NumberFlatValueConverter valueConverter = new NumberFlatValueConverter(Number::doubleValue);
        UUIDSqlValueConverter sqlKeyConverter = new UUIDSqlValueConverter("uuid");
        NumberSqlValueConverter sqlValueConverter = new NumberSqlValueConverter("balance", true, Number::doubleValue);
        switch (type.toLowerCase(Locale.ROOT)) {
            case "mysql": {
                MySqlDataStorageSupplier supplier = new MySqlDataStorageSupplier(((MainConfig)this.instance.get(MainConfig.class)).getSqlDatabaseSetting(false), JavaSqlClient::new);
                return supplier.getStorage("economy", (SqlValueConverter)sqlKeyConverter, (SqlValueConverter)sqlValueConverter);
            }
            case "sqlite": {
                SqliteDataStorageSupplier supplier = new SqliteDataStorageSupplier(this.instance.getDataFolder(), ((MainConfig)this.instance.get(MainConfig.class)).getSqlDatabaseSetting(true), JavaSqlClient::new);
                return supplier.getStorage("economy", (SqlValueConverter)sqlKeyConverter, (SqlValueConverter)sqlValueConverter);
            }
            case "json": {
                return new ConfigFileDataStorage<UUID, Double>(this.instance.getDataFolder(), "balances", (FlatValueConverter)keyConverter, (FlatValueConverter)valueConverter){

                    protected Config getConfig(File file) {
                        return new GsonConfig(file);
                    }

                    protected String getConfigName(String name) {
                        return name + ".json";
                    }
                };
            }
        }
        return new ConfigFileDataStorage<UUID, Double>(this.instance.getDataFolder(), "balances", (FlatValueConverter)keyConverter, (FlatValueConverter)valueConverter){

            protected Config getConfig(File file) {
                return new BukkitConfig(file);
            }

            protected String getConfigName(String name) {
                return name + ".yml";
            }
        };
    }

    public List<Agent> getAgents() {
        return this.agents;
    }

    public List<DataEntryAgent<UUID, Double>> getEntryAgents() {
        return this.entryAgents;
    }

    public void load() {
        this.storageAgent = new StorageAgent(this.getStorage());
        this.agents.add((Agent)this.storageAgent);
        this.entryAgents.add((DataEntryAgent<UUID, Double>)this.storageAgent);
        this.agents.add(this.storageAgent.getLoadAgent((DataHolder)this));
        this.agents.add((Agent)new SpigotRunnableAgent(this.storageAgent, (Scheduler)AsyncScheduler.get((Plugin)this.instance), (long)((MainConfig)this.instance.get(MainConfig.class)).getSaveFilePeriod()));
        this.snapshotAgent = SnapshotAgent.create((DataHolder)this);
        this.snapshotAgent.setComparator(Comparator.reverseOrder());
        this.snapshotAgent.setFilter(entry -> entry.getValue() != null);
        this.agents.add((Agent)this.snapshotAgent);
        this.agents.add((Agent)new SpigotRunnableAgent(this.snapshotAgent, (Scheduler)AsyncScheduler.get((Plugin)this.instance), (long)((MainConfig)this.instance.get(MainConfig.class)).getUpdateBalanceTopPeriod()));
    }

    public void enable() {
        this.register();
    }

    public void disable() {
        this.unregister();
    }

    public double get(UUID uuid) {
        return (Double)this.getOrCreateEntry(uuid).getValue();
    }

    public boolean hasAccount(UUID uuid) {
        return this.getOrCreateEntry(uuid).getValue() != null;
    }

    public boolean createAccount(UUID uuid) {
        if (this.hasAccount(uuid)) {
            return false;
        }
        this.getOrCreateEntry(uuid).setValue((Object)((MainConfig)this.instance.get(MainConfig.class)).getStartAmount());
        return true;
    }

    public boolean deleteAccount(UUID uuid) {
        if (!this.hasAccount(uuid)) {
            return false;
        }
        this.getOrCreateEntry(uuid).setValue((Object)null);
        return true;
    }

    public boolean has(UUID uuid, double amount) {
        return this.get(uuid) >= amount;
    }

    public boolean set(UUID uuid, double amount) {
        if (amount < ((MainConfig)this.instance.get(MainConfig.class)).getMinimumAmount()) {
            return false;
        }
        this.getOrCreateEntry(uuid).setValue((Object)amount);
        return true;
    }

    public boolean withdraw(UUID uuid, double amount) {
        return this.set(uuid, this.get(uuid) - amount);
    }

    public boolean deposit(UUID uuid, double amount) {
        return this.set(uuid, this.get(uuid) + amount);
    }

    @Generated
    public StorageAgent<UUID, Double> getStorageAgent() {
        return this.storageAgent;
    }

    @Generated
    public SnapshotAgent<UUID, Double> getSnapshotAgent() {
        return this.snapshotAgent;
    }
}

