/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.hook;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.hook.placeholderapi.EconomyPlaceholder;
import de.scholle.essentiax.extras.economy.hook.treasury.TreasuryEconomyHook;
import de.scholle.essentiax.extras.economy.hook.vault.VaultEconomyHook;
import io.github.projectunified.minelib.plugin.base.Loadable;
import java.util.ArrayList;
import java.util.List;
import me.lokka30.treasury.api.common.service.ServicePriority;
import me.lokka30.treasury.api.common.service.ServiceRegistry;
import me.lokka30.treasury.api.economy.EconomyProvider;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class HookProvider
implements Loadable {
    private final BetterEconomy instance;
    private final List<Runnable> disableTasks = new ArrayList<Runnable>();

    public HookProvider(BetterEconomy instance) {
        this.instance = instance;
    }

    public void load() {
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            Bukkit.getServicesManager().register(Economy.class, (Object)new VaultEconomyHook(this.instance), (Plugin)this.instance, org.bukkit.plugin.ServicePriority.High);
        }
        if (Bukkit.getPluginManager().getPlugin("Treasury") != null) {
            ServiceRegistry.INSTANCE.registerService(EconomyProvider.class, (Object)new TreasuryEconomyHook(this.instance), this.instance.getName(), ServicePriority.NORMAL);
        }
    }

    public void enable() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            EconomyPlaceholder economyPlaceholder = new EconomyPlaceholder(this.instance);
            economyPlaceholder.register();
            this.disableTasks.add(() -> ((EconomyPlaceholder)economyPlaceholder).unregister());
        }
    }

    public void disable() {
        this.disableTasks.forEach(Runnable::run);
    }
}

