/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.hook.placeholderapi;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.config.MainConfig;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EconomyPlaceholder
extends PlaceholderExpansion {
    private final BetterEconomy instance;

    public EconomyPlaceholder(BetterEconomy instance) {
        this.instance = instance;
    }

    @NotNull
    public String getIdentifier() {
        return "bettereconomy";
    }

    @NotNull
    public String getAuthor() {
        return Arrays.toString(this.instance.getDescription().getAuthors().toArray());
    }

    @NotNull
    public String getVersion() {
        return this.instance.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        EconomyHolder holder = (EconomyHolder)((Object)this.instance.get(EconomyHolder.class));
        String lower = params.toLowerCase(Locale.ROOT);
        if (lower.startsWith("top_")) {
            int i;
            Function<Map.Entry, String> function;
            String index;
            String query = lower.substring(4);
            if (query.isEmpty()) {
                return null;
            }
            if (query.startsWith("name_")) {
                index = query.substring(5);
                function = snapshot -> Bukkit.getOfflinePlayer((UUID)((UUID)snapshot.getKey())).getName();
            } else if (query.startsWith("uuid_")) {
                index = query.substring(5);
                function = snapshot -> ((UUID)snapshot.getKey()).toString();
            } else if (query.startsWith("balance_formatted_")) {
                index = query.substring(18);
                function = snapshot -> ((MainConfig)this.instance.get(MainConfig.class)).format((Double)snapshot.getValue());
            } else if (query.startsWith("balance_")) {
                index = query.substring(8);
                function = snapshot -> String.valueOf(snapshot.getValue());
            } else {
                return null;
            }
            try {
                i = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                return null;
            }
            return holder.getSnapshotAgent().getSnapshotByIndex(i - 1).map(function).orElse(null);
        }
        if (player == null) {
            return null;
        }
        switch (lower) {
            case "balance": {
                return String.valueOf(holder.get(player.getUniqueId()));
            }
            case "balance_formatted": {
                return ((MainConfig)this.instance.get(MainConfig.class)).format(holder.get(player.getUniqueId()));
            }
            case "top": {
                return String.valueOf(holder.getSnapshotAgent().getSnapshotIndex((Object)player.getUniqueId()) + 1);
            }
        }
        return null;
    }
}

