/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.hook.treasury;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.Utils;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import de.scholle.essentiax.extras.economy.hook.treasury.FailureReasons;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lokka30.treasury.api.common.misc.FutureHelper;
import me.lokka30.treasury.api.economy.account.PlayerAccount;
import me.lokka30.treasury.api.economy.currency.Currency;
import me.lokka30.treasury.api.economy.transaction.EconomyTransaction;
import me.lokka30.treasury.api.economy.transaction.EconomyTransactionType;
import org.jetbrains.annotations.NotNull;

public class TreasuryAccount
implements PlayerAccount {
    private final BetterEconomy instance;
    private final UUID uuid;

    public TreasuryAccount(BetterEconomy instance, UUID uuid) {
        this.instance = instance;
        this.uuid = uuid;
    }

    @NotNull
    public UUID identifier() {
        return this.uuid;
    }

    @NotNull
    public Optional<String> getName() {
        return Optional.ofNullable(Utils.getOfflinePlayer(this.uuid).getName());
    }

    @NotNull
    public CompletableFuture<BigDecimal> retrieveBalance(@NotNull Currency currency) {
        if (!currency.getIdentifier().equals("better_economy_currency")) {
            return FutureHelper.failedFuture((Throwable)FailureReasons.CURRENCY_NOT_FOUND.toException());
        }
        return CompletableFuture.supplyAsync(() -> BigDecimal.valueOf(((EconomyHolder)((Object)((Object)this.instance.get(EconomyHolder.class)))).get(this.uuid)));
    }

    @NotNull
    public CompletableFuture<BigDecimal> doTransaction(@NotNull EconomyTransaction economyTransaction) {
        return CompletableFuture.supplyAsync(() -> {
            if (!economyTransaction.getCurrencyId().equals("better_economy_currency")) {
                throw FailureReasons.CURRENCY_NOT_FOUND.toException();
            }
            EconomyTransactionType type = economyTransaction.getType();
            BigDecimal amount = economyTransaction.getAmount();
            double amountDouble = amount.doubleValue();
            if (amountDouble < 0.0) {
                throw FailureReasons.NEGATIVE_BALANCES_NOT_SUPPORTED.toException();
            }
            EconomyHolder holder = (EconomyHolder)((Object)((Object)this.instance.get(EconomyHolder.class)));
            boolean status = false;
            if (type == EconomyTransactionType.DEPOSIT) {
                status = holder.deposit(this.uuid, amountDouble);
            } else if (type == EconomyTransactionType.WITHDRAWAL) {
                status = holder.withdraw(this.uuid, amountDouble);
            }
            if (!status) {
                throw FailureReasons.NEGATIVE_BALANCES_NOT_SUPPORTED.toException();
            }
            return BigDecimal.valueOf(holder.get(this.uuid));
        });
    }

    @NotNull
    public CompletableFuture<Boolean> deleteAccount() {
        return CompletableFuture.supplyAsync(() -> ((EconomyHolder)((Object)((Object)this.instance.get(EconomyHolder.class)))).deleteAccount(this.uuid));
    }

    @NotNull
    public CompletableFuture<Collection<String>> retrieveHeldCurrencies() {
        return CompletableFuture.completedFuture(Collections.singletonList("better_economy_currency"));
    }

    @NotNull
    public CompletableFuture<Collection<EconomyTransaction>> retrieveTransactionHistory(int transactionCount, @NotNull Temporal from, @NotNull Temporal to) {
        return FutureHelper.failedFuture((Throwable)FailureReasons.FEATURE_NOT_SUPPORTED.toException());
    }
}

