/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.hook.treasury;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.config.MainConfig;
import de.scholle.essentiax.extras.economy.hook.treasury.FailureReasons;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.lokka30.treasury.api.common.misc.FutureHelper;
import me.lokka30.treasury.api.economy.account.Account;
import me.lokka30.treasury.api.economy.currency.Currency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreasuryCurrency
implements Currency {
    private final BetterEconomy instance;

    public TreasuryCurrency(BetterEconomy instance) {
        this.instance = instance;
    }

    @NotNull
    public String getIdentifier() {
        return "better_economy_currency";
    }

    @NotNull
    public String getSymbol() {
        return ((MainConfig)this.instance.get(MainConfig.class)).getCurrencySymbol();
    }

    public char getDecimal(@Nullable Locale locale) {
        return ((MainConfig)this.instance.get(MainConfig.class)).getActualDecimalPoint();
    }

    @NotNull
    public Map<Locale, Character> getLocaleDecimalMap() {
        return Collections.singletonMap(Locale.getDefault(), Character.valueOf(((MainConfig)this.instance.get(MainConfig.class)).getActualDecimalPoint()));
    }

    @NotNull
    public String getDisplayName(@NotNull BigDecimal value, @Nullable Locale locale) {
        if (value.compareTo(BigDecimal.ONE) <= 0) {
            return ((MainConfig)this.instance.get(MainConfig.class)).getCurrencySingular();
        }
        return ((MainConfig)this.instance.get(MainConfig.class)).getCurrencyPlural();
    }

    public int getPrecision() {
        return ((MainConfig)this.instance.get(MainConfig.class)).getFractionalDigits();
    }

    public boolean isPrimary() {
        return true;
    }

    @NotNull
    public BigDecimal getStartingBalance(@NotNull Account account) {
        return BigDecimal.valueOf(((MainConfig)this.instance.get(MainConfig.class)).getStartAmount());
    }

    @NotNull
    public BigDecimal getConversionRate() {
        return BigDecimal.ZERO;
    }

    @NotNull
    public CompletableFuture<BigDecimal> parse(@NotNull String formattedAmount, @Nullable Locale locale) {
        StringBuilder valueBuilder = new StringBuilder();
        StringBuilder currencyBuilder = new StringBuilder();
        boolean hadDot = false;
        for (char c : formattedAmount.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            if (!Character.isDigit(c) && !this.isSeparator(c, locale)) {
                currencyBuilder.append(c);
                continue;
            }
            if (Character.isDigit(c)) {
                valueBuilder.append(c);
                continue;
            }
            if (!this.isSeparator(c, locale)) continue;
            if (c == this.getDecimal(locale)) {
                boolean nowChanged = false;
                if (!hadDot) {
                    hadDot = true;
                    nowChanged = true;
                }
                if (!nowChanged) {
                    valueBuilder = new StringBuilder();
                    break;
                }
            }
            valueBuilder.append('.');
        }
        if (currencyBuilder.length() == 0) {
            return FutureHelper.failedFuture((Throwable)FailureReasons.INVALID_CURRENCY.toException());
        }
        String currency = currencyBuilder.toString();
        if (!this.matches(currency, locale)) {
            return FutureHelper.failedFuture((Throwable)FailureReasons.INVALID_CURRENCY.toException());
        }
        if (valueBuilder.length() == 0) {
            return FutureHelper.failedFuture((Throwable)FailureReasons.INVALID_VALUE.toException());
        }
        try {
            double value = Double.parseDouble(valueBuilder.toString());
            if (value < 0.0) {
                return FutureHelper.failedFuture((Throwable)FailureReasons.NEGATIVE_BALANCES_NOT_SUPPORTED.toException());
            }
            return CompletableFuture.completedFuture(BigDecimal.valueOf(value));
        }
        catch (NumberFormatException e) {
            return FutureHelper.failedFuture((Throwable)FailureReasons.INVALID_VALUE.toException(e));
        }
    }

    private boolean matches(String currency, @Nullable Locale locale) {
        if (currency.length() == 1) {
            return currency.charAt(0) == this.getDecimal(locale);
        }
        return currency.equalsIgnoreCase(this.getSymbol()) || currency.equalsIgnoreCase(((MainConfig)this.instance.get(MainConfig.class)).getCurrencySingular()) || currency.equalsIgnoreCase(((MainConfig)this.instance.get(MainConfig.class)).getCurrencyPlural());
    }

    private boolean isSeparator(char c, @Nullable Locale locale) {
        return c == this.getDecimal(locale) || c == ((MainConfig)this.instance.get(MainConfig.class)).getActualThousandsSeparator();
    }

    @NotNull
    public String format(@NotNull BigDecimal amount, @Nullable Locale locale) {
        return ((MainConfig)this.instance.get(MainConfig.class)).format(amount);
    }

    @NotNull
    public String format(@NotNull BigDecimal amount, @Nullable Locale locale, int precision) {
        return ((MainConfig)this.instance.get(MainConfig.class)).format(amount, precision);
    }
}

