/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.extras.economy.hook.treasury;

import de.scholle.essentiax.extras.economy.BetterEconomy;
import de.scholle.essentiax.extras.economy.holder.EconomyHolder;
import de.scholle.essentiax.extras.economy.hook.treasury.FailureReasons;
import de.scholle.essentiax.extras.economy.hook.treasury.TreasuryAccountAccessor;
import de.scholle.essentiax.extras.economy.hook.treasury.TreasuryCurrency;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lokka30.treasury.api.common.NamespacedKey;
import me.lokka30.treasury.api.common.misc.FutureHelper;
import me.lokka30.treasury.api.common.misc.TriState;
import me.lokka30.treasury.api.economy.EconomyProvider;
import me.lokka30.treasury.api.economy.account.AccountData;
import me.lokka30.treasury.api.economy.account.accessor.AccountAccessor;
import me.lokka30.treasury.api.economy.currency.Currency;
import org.jetbrains.annotations.NotNull;

public class TreasuryEconomyHook
implements EconomyProvider {
    public static final String CURRENCY_IDENTIFIER = "better_economy_currency";
    private final BetterEconomy instance;
    private final Currency currency;
    private final AccountAccessor accountAccessor;

    public TreasuryEconomyHook(BetterEconomy instance) {
        this.instance = instance;
        this.currency = new TreasuryCurrency(instance);
        this.accountAccessor = new TreasuryAccountAccessor(instance);
    }

    @NotNull
    public AccountAccessor accountAccessor() {
        return this.accountAccessor;
    }

    @NotNull
    public CompletableFuture<Boolean> hasAccount(@NotNull AccountData accountData) {
        if (accountData.isPlayerAccount()) {
            return CompletableFuture.supplyAsync(() -> ((EconomyHolder)((Object)((Object)this.instance.get(EconomyHolder.class)))).hasAccount((UUID)accountData.getPlayerIdentifier().get()));
        }
        return FutureHelper.failedFuture((Throwable)FailureReasons.FEATURE_NOT_SUPPORTED.toException());
    }

    @NotNull
    public CompletableFuture<Collection<UUID>> retrievePlayerAccountIds() {
        return CompletableFuture.supplyAsync(() -> ((EconomyHolder)((Object)((Object)this.instance.get(EconomyHolder.class)))).getEntryMap().keySet());
    }

    @NotNull
    public CompletableFuture<Collection<NamespacedKey>> retrieveNonPlayerAccountIds() {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @NotNull
    public Currency getPrimaryCurrency() {
        return this.currency;
    }

    @NotNull
    public Optional<Currency> findCurrency(@NotNull String identifier) {
        return this.currency.getIdentifier().equals(CURRENCY_IDENTIFIER) ? Optional.of(this.currency) : Optional.empty();
    }

    @NotNull
    public Set<Currency> getCurrencies() {
        return Collections.singleton(this.currency);
    }

    @NotNull
    public CompletableFuture<TriState> registerCurrency(@NotNull Currency currency) {
        return CompletableFuture.completedFuture(TriState.FALSE);
    }

    @NotNull
    public CompletableFuture<TriState> unregisterCurrency(@NotNull Currency currency) {
        return CompletableFuture.completedFuture(TriState.FALSE);
    }
}

