/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class Announcement {
    private final EssentiaX plugin;
    private String prefix;

    public Announcement(EssentiaX plugin) {
        this.plugin = plugin;
        this.loadPrefixFromConfig();
        plugin.getCommand("announce").setExecutor((CommandExecutor)new AnnounceCommand());
        plugin.getLogger().info("Announcement feature loaded!");
    }

    private void loadPrefixFromConfig() {
        ChatColor prefixColor;
        String prefixText = this.plugin.getConfig().getString("announcement.prefix.text", "Announcement");
        String prefixColorName = this.plugin.getConfig().getString("announcement.prefix.color", "AQUA");
        try {
            prefixColor = ChatColor.valueOf((String)prefixColorName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            prefixColor = ChatColor.AQUA;
        }
        this.prefix = ChatColor.WHITE + ChatColor.BOLD + "[" + prefixColor + ChatColor.BOLD + prefixText + ChatColor.WHITE + ChatColor.BOLD + "] " + ChatColor.RESET + ChatColor.BOLD;
    }

    private void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(this.prefix + ChatColor.RESET + message);
    }

    private class AnnounceCommand
    implements CommandExecutor {
        private final Map<String, ChatColor> colorMap = new HashMap<String, ChatColor>();

        public AnnounceCommand() {
            this.colorMap.put("black", ChatColor.BLACK);
            this.colorMap.put("dark_blue", ChatColor.DARK_BLUE);
            this.colorMap.put("dark_green", ChatColor.DARK_GREEN);
            this.colorMap.put("dark_aqua", ChatColor.DARK_AQUA);
            this.colorMap.put("dark_red", ChatColor.DARK_RED);
            this.colorMap.put("dark_purple", ChatColor.DARK_PURPLE);
            this.colorMap.put("gold", ChatColor.GOLD);
            this.colorMap.put("gray", ChatColor.GRAY);
            this.colorMap.put("dark_gray", ChatColor.DARK_GRAY);
            this.colorMap.put("blue", ChatColor.BLUE);
            this.colorMap.put("green", ChatColor.GREEN);
            this.colorMap.put("aqua", ChatColor.AQUA);
            this.colorMap.put("red", ChatColor.RED);
            this.colorMap.put("light_purple", ChatColor.LIGHT_PURPLE);
            this.colorMap.put("yellow", ChatColor.YELLOW);
            this.colorMap.put("white", ChatColor.WHITE);
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission("essentiax.announce")) {
                Announcement.this.sendMessage(sender, ChatColor.RED + "You don't have permission to use this command!");
                return true;
            }
            if (args.length < 1) {
                Announcement.this.sendMessage(sender, ChatColor.RED + "Usage: /announce <message> [color]");
                return true;
            }
            String colorName = args.length > 1 ? args[args.length - 1].toLowerCase() : "yellow";
            ChatColor color = this.colorMap.getOrDefault(colorName, ChatColor.YELLOW);
            StringBuilder messageBuilder = new StringBuilder();
            int end = args.length > 1 ? args.length - 1 : args.length;
            for (int i = 0; i < end; ++i) {
                messageBuilder.append(args[i]).append(" ");
            }
            String message = messageBuilder.toString().trim();
            Bukkit.getOnlinePlayers().forEach(player -> Announcement.this.sendMessage((CommandSender)player, color + message));
            Announcement.this.sendMessage(sender, ChatColor.GREEN + "Announcement sent!");
            return true;
        }
    }
}

