/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.Language;
import de.scholle.essentiax.Mute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Reply
implements CommandExecutor,
TabCompleter {
    private final EssentiaX plugin;
    private final Map<UUID, UUID> lastMessaged = new HashMap<UUID, UUID>();
    private final Mute mute;
    private final Language lang;

    public Reply(EssentiaX plugin, Mute mute, Language lang) {
        this.plugin = plugin;
        this.mute = mute;
        this.lang = lang;
    }

    public void setLastMessaged(Player sender, Player receiver) {
        this.lastMessaged.put(sender.getUniqueId(), receiver.getUniqueId());
        this.lastMessaged.put(receiver.getUniqueId(), sender.getUniqueId());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfig().getBoolean("reply.enabled", true)) {
            player.sendMessage(this.lang.get("reply.disabled"));
            return true;
        }
        if (!player.hasPermission("essentia.reply")) {
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.lang.get("reply.usage"));
            return true;
        }
        UUID targetUUID = this.lastMessaged.get(player.getUniqueId());
        if (targetUUID == null) {
            player.sendMessage(this.lang.get("reply.no_target"));
            return true;
        }
        Player target = Bukkit.getPlayer((UUID)targetUUID);
        if (target == null || !target.isOnline()) {
            player.sendMessage(this.lang.get("reply.offline"));
            return true;
        }
        if (this.plugin.getConfig().getBoolean("mute.enabled", true) && this.mute.isMuted(player.getUniqueId(), target.getUniqueId())) {
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        HashMap<String, String> placeholdersFrom = new HashMap<String, String>();
        placeholdersFrom.put("player", player.getName());
        placeholdersFrom.put("message", message);
        HashMap<String, String> placeholdersTo = new HashMap<String, String>();
        placeholdersTo.put("player", target.getName());
        placeholdersTo.put("message", message);
        target.sendMessage(this.lang.get("reply.from", placeholdersFrom));
        player.sendMessage(this.lang.get("reply.to", placeholdersTo));
        this.setLastMessaged(player, target);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }
}

